/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.verifier.model.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugin.verifier.model.File;
import org.apache.maven.plugin.verifier.model.Verifications;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class VerificationsXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, Verifications verifications) throws IOException {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.writeVerifications(verifications, "verifications", this.serializer);
    }

    private void writeFile(File file, String tagName, XmlSerializer serializer) throws IOException {
        if (file != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (file.getLocation() != null) {
                serializer.startTag(this.NAMESPACE, "location").text(file.getLocation()).endTag(this.NAMESPACE, "location");
            }
            if (file.getContains() != null) {
                serializer.startTag(this.NAMESPACE, "contains").text(file.getContains()).endTag(this.NAMESPACE, "contains");
            }
            if (!file.isExists()) {
                serializer.startTag(this.NAMESPACE, "exists").text(String.valueOf(file.isExists())).endTag(this.NAMESPACE, "exists");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeVerifications(Verifications verifications, String tagName, XmlSerializer serializer) throws IOException {
        if (verifications != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (verifications.getFiles() != null && verifications.getFiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "files");
                Iterator iter = verifications.getFiles().iterator();
                while (iter.hasNext()) {
                    File file = (File)iter.next();
                    this.writeFile(file, "file", serializer);
                }
                serializer.endTag(this.NAMESPACE, "files");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

