/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.overlay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.overlay.DefaultOverlay;
import org.apache.maven.plugin.war.overlay.InvalidOverlayConfigurationException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlayManager {
    private final List<Overlay> overlays = new ArrayList<Overlay>();
    private final MavenProject project;
    private final List<Artifact> artifactsOverlays;

    public OverlayManager(List<Overlay> overlays, MavenProject project, String defaultIncludes, String defaultExcludes, Overlay currentProjectOverlay) throws InvalidOverlayConfigurationException {
        if (overlays != null) {
            this.overlays.addAll(overlays);
        }
        this.project = project;
        this.artifactsOverlays = this.getOverlaysAsArtifacts();
        this.initialize(defaultIncludes, defaultExcludes, currentProjectOverlay);
    }

    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    public List<String> getOverlayIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (Overlay overlay : this.overlays) {
            result.add(overlay.getId());
        }
        return result;
    }

    void initialize(String defaultIncludes, String defaultExcludes, Overlay currentProjectOverlay) throws InvalidOverlayConfigurationException {
        ArrayList<Artifact> configuredWarArtifacts = new ArrayList<Artifact>();
        ListIterator<Overlay> it = this.overlays.listIterator();
        while (it.hasNext()) {
            Artifact artifact;
            Overlay overlay = it.next();
            if (overlay == null) {
                throw new InvalidOverlayConfigurationException("overlay could not be null.");
            }
            if (overlay.isCurrentProject()) {
                overlay = currentProjectOverlay;
                it.set(overlay);
            }
            if (Arrays.equals(Overlay.DEFAULT_INCLUDES, overlay.getIncludes()) && Arrays.equals(Overlay.DEFAULT_EXCLUDES, overlay.getExcludes())) {
                overlay.setIncludes(defaultIncludes);
                overlay.setExcludes(defaultExcludes);
            }
            if ((artifact = this.getAssociatedArtifact(overlay)) == null) continue;
            configuredWarArtifacts.add(artifact);
            overlay.setArtifact(artifact);
        }
        for (Artifact artifact : this.artifactsOverlays) {
            if (configuredWarArtifacts.contains(artifact)) continue;
            this.overlays.add(new DefaultOverlay(artifact, defaultIncludes, defaultExcludes));
        }
        for (Overlay overlay : this.overlays) {
            if (!overlay.equals(currentProjectOverlay)) continue;
            return;
        }
        this.overlays.add(0, currentProjectOverlay);
    }

    Artifact getAssociatedArtifact(Overlay overlay) throws InvalidOverlayConfigurationException {
        if (overlay.isCurrentProject()) {
            return null;
        }
        for (Artifact artifact : this.artifactsOverlays) {
            if (!this.compareOverlayWithArtifact(overlay, artifact)) continue;
            return artifact;
        }
        Set projectArtifacts = this.project.getDependencyArtifacts();
        if (projectArtifacts != null) {
            for (Artifact artifact : projectArtifacts) {
                if (!this.compareOverlayWithArtifact(overlay, artifact)) continue;
                return artifact;
            }
        }
        throw new InvalidOverlayConfigurationException("overlay [" + overlay + "] is not a dependency of the project.");
    }

    private boolean compareOverlayWithArtifact(Overlay overlay, Artifact artifact) {
        return StringUtils.equals((String)overlay.getGroupId(), (String)artifact.getGroupId()) && StringUtils.equals((String)overlay.getArtifactId(), (String)artifact.getArtifactId()) && StringUtils.equals((String)overlay.getType(), (String)artifact.getType()) && StringUtils.equals((String)StringUtils.defaultString((Object)overlay.getClassifier()), (String)StringUtils.defaultString((Object)artifact.getClassifier()));
    }

    private List<Artifact> getOverlaysAsArtifacts() {
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        Set artifacts = this.project.getArtifacts();
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (artifact.isOptional() || !filter.include(artifact) || !"war".equals(artifact.getType())) continue;
            result.add(artifact);
        }
        return result;
    }
}

