/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.war.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.war.Overlay;
import org.apache.maven.plugins.war.packaging.AbstractWarPackagingTask;
import org.apache.maven.plugins.war.packaging.ArtifactsPackagingTask;
import org.apache.maven.plugins.war.packaging.ClassesPackagingTask;
import org.apache.maven.plugins.war.packaging.WarPackagingContext;
import org.apache.maven.plugins.war.util.PathSet;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class WarProjectPackagingTask
extends AbstractWarPackagingTask {
    private final Resource[] webResources;
    private final File webXml;
    private final File containerConfigXML;
    private final String id;
    private Overlay currentProjectOverlay;

    public WarProjectPackagingTask(Resource[] webResources, File webXml, File containerConfigXml, Overlay currentProjectOverlay) {
        this.webResources = webResources != null ? webResources : new Resource[0];
        this.webXml = webXml;
        this.containerConfigXML = containerConfigXml;
        this.currentProjectOverlay = currentProjectOverlay;
        this.id = currentProjectOverlay.getId();
    }

    @Override
    public void performPackaging(WarPackagingContext context) throws MojoExecutionException, MojoFailureException {
        context.getLog().info((CharSequence)"Processing war project");
        File webinfDir = new File(context.getWebappDirectory(), "WEB-INF");
        webinfDir.mkdirs();
        File metainfDir = new File(context.getWebappDirectory(), "META-INF");
        metainfDir.mkdirs();
        this.handleWebResources(context);
        this.handleWebAppSourceDirectory(context);
        PathSet pathSet = context.getWebappStructure().getStructure("currentBuild");
        context.getLog().debug((CharSequence)"Dump of the current build pathSet content -->");
        for (String path : pathSet) {
            context.getLog().debug((CharSequence)path);
        }
        context.getLog().debug((CharSequence)"-- end of dump --");
        this.handleDeploymentDescriptors(context, webinfDir, metainfDir, context.isFailOnMissingWebXml());
        this.handleClassesDirectory(context);
        this.handleArtifacts(context);
        if (!context.getWebappDirectory().mkdirs()) {
            for (String resource : context.getOutdatedResources()) {
                new File(context.getWebappDirectory(), resource).delete();
            }
        }
    }

    protected void handleWebResources(WarPackagingContext context) throws MojoExecutionException {
        for (Resource resource : this.webResources) {
            if (resource.getDirectory() == null) {
                throw new MojoExecutionException("The <directory> tag is missing from the <resource> tag.");
            }
            if (!new File(resource.getDirectory()).isAbsolute()) {
                resource.setDirectory(context.getProject().getBasedir() + File.separator + resource.getDirectory());
            }
            if (resource.getDirectory().equals(context.getWebappDirectory().getPath())) continue;
            try {
                this.copyResources(context, resource);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy resource [" + resource.getDirectory() + "]", (Exception)e);
            }
        }
    }

    protected void handleWebAppSourceDirectory(WarPackagingContext context) throws MojoExecutionException {
        if (!context.getWebappSourceDirectory().exists()) {
            context.getLog().debug((CharSequence)"webapp sources directory does not exist - skipping.");
        } else if (!context.getWebappSourceDirectory().getAbsolutePath().equals(context.getWebappDirectory().getPath())) {
            context.getLog().info((CharSequence)("Copying webapp resources [" + context.getWebappSourceDirectory() + "]"));
            PathSet sources = this.getFilesToIncludes(context.getWebappSourceDirectory(), context.getWebappSourceIncludes(), context.getWebappSourceExcludes(), context.isWebappSourceIncludeEmptyDirectories());
            try {
                this.copyFiles(this.id, context, context.getWebappSourceDirectory(), sources, false);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy webapp sources [" + context.getWebappDirectory().getAbsolutePath() + "]", (Exception)e);
            }
        }
    }

    protected void handleArtifacts(WarPackagingContext context) throws MojoExecutionException {
        ArtifactsPackagingTask task = new ArtifactsPackagingTask(context.getProject().getArtifacts(), this.currentProjectOverlay);
        task.performPackaging(context);
    }

    protected void handleClassesDirectory(WarPackagingContext context) throws MojoExecutionException {
        ClassesPackagingTask task = new ClassesPackagingTask(this.currentProjectOverlay);
        task.performPackaging(context);
    }

    protected void handleDeploymentDescriptors(WarPackagingContext context, File webinfDir, File metainfDir, Boolean failOnMissingWebXml) throws MojoFailureException, MojoExecutionException {
        try {
            if (this.webXml != null && StringUtils.isNotEmpty((String)this.webXml.getName())) {
                if (!this.webXml.exists() && (failOnMissingWebXml == null || Boolean.TRUE.equals(failOnMissingWebXml))) {
                    throw new MojoFailureException("The specified web.xml file '" + this.webXml + "' does not exist");
                }
                context.getWebappStructure().registerFileForced(this.id, "WEB-INF/web.xml");
                if (context.isFilteringDeploymentDescriptors()) {
                    context.getMavenFileFilter().copyFile(this.webXml, new File(webinfDir, "web.xml"), true, context.getFilterWrappers(), this.getEncoding(this.webXml));
                } else {
                    this.copyFile(context, this.webXml, new File(webinfDir, "web.xml"), "WEB-INF/web.xml", true);
                }
            } else {
                File defaultWebXml = new File(context.getWebappSourceDirectory(), "WEB-INF/web.xml");
                if (defaultWebXml.exists() && context.isFilteringDeploymentDescriptors()) {
                    context.getWebappStructure().registerFile(this.id, "WEB-INF/web.xml");
                    context.getMavenFileFilter().copyFile(defaultWebXml, new File(webinfDir, "web.xml"), true, context.getFilterWrappers(), this.getEncoding(defaultWebXml));
                }
            }
            if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
                String xmlFileName = this.containerConfigXML.getName();
                context.getWebappStructure().registerFileForced(this.id, "META-INF/" + xmlFileName);
                if (context.isFilteringDeploymentDescriptors()) {
                    context.getMavenFileFilter().copyFile(this.containerConfigXML, new File(metainfDir, xmlFileName), true, context.getFilterWrappers(), this.getEncoding(this.containerConfigXML));
                } else {
                    this.copyFile(context, this.containerConfigXML, new File(metainfDir, xmlFileName), "META-INF/" + xmlFileName, true);
                }
            }
        }
        catch (IOException e) {
            if (failOnMissingWebXml == null || Boolean.TRUE.equals(failOnMissingWebXml)) {
                throw new MojoExecutionException("Failed to copy deployment descriptor", (Exception)e);
            }
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Failed to copy deployment descriptor", (Exception)((Object)e));
        }
    }

    public void copyResources(WarPackagingContext context, Resource resource) throws IOException, MojoExecutionException {
        String[] fileNames;
        if (!context.getWebappDirectory().exists()) {
            context.getLog().warn((CharSequence)("Not copying webapp webResources [" + resource.getDirectory() + "]: webapp directory [" + context.getWebappDirectory().getAbsolutePath() + "] does not exist!"));
        }
        context.getLog().info((CharSequence)("Copying webapp webResources [" + resource.getDirectory() + "] to [" + context.getWebappDirectory().getAbsolutePath() + "]"));
        String[] stringArray = fileNames = this.getFilesToCopy(resource);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String fileName;
            String targetFileName = fileName = stringArray[i];
            if (resource.getTargetPath() != null && !StringUtils.equals((String)".", (String)resource.getTargetPath()) && !StringUtils.equals((String)"./", (String)resource.getTargetPath())) {
                targetFileName = resource.getTargetPath() + File.separator + targetFileName;
            }
            if (resource.isFiltering() && !context.isNonFilteredExtension(fileName)) {
                this.copyFilteredFile(this.id, context, new File(resource.getDirectory(), fileName), targetFileName);
                continue;
            }
            this.copyFile(this.id, context, new File(resource.getDirectory(), fileName), targetFileName);
        }
    }

    private String[] getFilesToCopy(Resource resource) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            scanner.setIncludes(resource.getIncludes().toArray(new String[resource.getIncludes().size()]));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            scanner.setExcludes(resource.getExcludes().toArray(new String[resource.getExcludes().size()]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

