/*
 * $Id$
 */

package org.apache.maven.shared.model.fileset.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.SetBase;
import org.codehaus.plexus.util.xml.pull.*;

/**
 * Class FileSetXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class FileSetXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field serializer
     */
    private org.codehaus.plexus.util.xml.pull.XmlSerializer serializer;

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param fileSet
     */
    public void write(Writer writer, FileSet fileSet)
        throws java.io.IOException
    {
        serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( fileSet.getModelEncoding(), null );
        writeFileSet( fileSet, "fileSet", serializer );
        serializer.endDocument();
    } //-- void write(Writer, FileSet) 

    /**
     * Method writeFileSet
     * 
     * @param fileSet
     * @param serializer
     * @param tagName
     */
    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( fileSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileSet.getDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "directory" ).text( fileSet.getDirectory() ).endTag( NAMESPACE, "directory" );
            }
            if ( fileSet.getLineEnding() != null )
            {
                serializer.startTag( NAMESPACE, "lineEnding" ).text( fileSet.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
            }
            if ( fileSet.isFollowSymlinks() != false )
            {
                serializer.startTag( NAMESPACE, "followSymlinks" ).text( String.valueOf( fileSet.isFollowSymlinks() ) ).endTag( NAMESPACE, "followSymlinks" );
            }
            if ( fileSet.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileSet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( fileSet.getFileMode() != null && !fileSet.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( fileSet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( fileSet.getDirectoryMode() != null && !fileSet.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( fileSet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileSet(FileSet, String, XmlSerializer) 

    /**
     * Method writeSetBase
     * 
     * @param setBase
     * @param serializer
     * @param tagName
     */
    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( setBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( setBase.isFollowSymlinks() != false )
            {
                serializer.startTag( NAMESPACE, "followSymlinks" ).text( String.valueOf( setBase.isFollowSymlinks() ) ).endTag( NAMESPACE, "followSymlinks" );
            }
            if ( setBase.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( setBase.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( setBase.getIncludes() != null && setBase.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = setBase.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( setBase.getExcludes() != null && setBase.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = setBase.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( setBase.getFileMode() != null && !setBase.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( setBase.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( setBase.getDirectoryMode() != null && !setBase.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( setBase.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSetBase(SetBase, String, XmlSerializer) 

}
