/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.fileset.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.util.DirectoryScanner;

public class FileSetManager {
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final boolean verbose;
    private final Log log;

    public FileSetManager(Log log, boolean verbose) {
        this.log = log;
        this.verbose = verbose;
    }

    public FileSetManager(Log log) {
        this.log = log;
        this.verbose = false;
    }

    public FileSetManager() {
        this.log = null;
        this.verbose = false;
    }

    public String[] getIncludedFiles(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getIncludedFiles();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getIncludedDirectories(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getIncludedDirectories();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getExcludedFiles(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getExcludedFiles();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getExcludedDirectories(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getExcludedDirectories();
        }
        return EMPTY_STRING_ARRAY;
    }

    public void delete(FileSet fileSet) throws IOException {
        Set deletablePaths = this.findDeletablePaths(fileSet);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Found deletable paths: " + String.valueOf(deletablePaths).replace(',', '\n')));
        }
        Iterator it = deletablePaths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            File file = new File(fileSet.getDirectory(), path);
            if (!file.exists()) continue;
            if (file.isDirectory() && (fileSet.isFollowSymlinks() || !this.isSymlink(file))) {
                if (this.verbose && this.log != null) {
                    this.log.info((CharSequence)("Deleting directory: " + file));
                }
                this.removeDir(file, fileSet.isFollowSymlinks());
                continue;
            }
            if (this.verbose && this.log != null) {
                this.log.info((CharSequence)("Deleting file: " + file));
            }
            if (this.delete(file)) continue;
            throw new IOException("Failed to delete file: " + file + ". Reason is unknown.");
        }
    }

    private boolean isSymlink(File file) throws IOException {
        File parent = file.getParentFile();
        File canonicalFile = file.getCanonicalFile();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Checking for symlink:\nParent file's canonical path: " + parent.getCanonicalPath() + "\nMy canonical path: " + canonicalFile.getPath()));
        }
        return parent != null && (!canonicalFile.getName().equals(file.getName()) || !canonicalFile.getPath().startsWith(parent.getCanonicalPath()));
    }

    private Set findDeletablePaths(FileSet fileSet) {
        Set includes = this.findDeletableDirectories(fileSet);
        includes.addAll(this.findDeletableFiles(fileSet, includes));
        return includes;
    }

    private Set findDeletableDirectories(FileSet fileSet) {
        DirectoryScanner scanner;
        if (this.verbose && this.log != null) {
            this.log.info((CharSequence)"Scanning for deletable directories.");
        }
        if ((scanner = this.scan(fileSet)) == null) {
            return Collections.EMPTY_SET;
        }
        String[] includedDirs = scanner.getIncludedDirectories();
        String[] excludedDirs = scanner.getExcludedDirectories();
        HashSet<String> includes = new HashSet<String>(Arrays.asList(includedDirs));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(excludedDirs));
        ArrayList<String> linksForDeletion = new ArrayList<String>();
        if (!fileSet.isFollowSymlinks()) {
            if (this.verbose && this.log != null) {
                this.log.info((CharSequence)"Adding symbolic link dirs which were previously excluded to the list being deleted.");
            }
            scanner.setFollowSymlinks(true);
            scanner.scan();
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Originally marked for delete: " + includes));
                this.log.debug((CharSequence)("Marked for preserve (with followSymlinks == false): " + excludes));
            }
            List<String> notSymlinks = Arrays.asList(scanner.getIncludedDirectories());
            linksForDeletion.addAll(excludes);
            linksForDeletion.retainAll(notSymlinks);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Symlinks marked for deletion (originally mismarked): " + linksForDeletion));
            }
            excludes.removeAll(notSymlinks);
        }
        for (int i = 0; i < excludedDirs.length; ++i) {
            String path = excludedDirs[i];
            File excluded = new File(path);
            String parentPath = excluded.getParent();
            while (parentPath != null) {
                boolean removed;
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Verifying path: " + parentPath + " is not present; contains file which is excluded."));
                }
                if ((removed = includes.remove(parentPath)) && this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Path: " + parentPath + " was removed from delete list."));
                }
                parentPath = new File(parentPath).getParent();
            }
        }
        includes.addAll(linksForDeletion);
        return includes;
    }

    private Set findDeletableFiles(FileSet fileSet, Set deletableDirectories) {
        DirectoryScanner scanner;
        if (this.verbose && this.log != null) {
            this.log.info((CharSequence)"Re-scanning for deletable files.");
        }
        if ((scanner = this.scan(fileSet)) == null) {
            return deletableDirectories;
        }
        String[] includedFiles = scanner.getIncludedFiles();
        String[] excludedFiles = scanner.getExcludedFiles();
        Set includes = deletableDirectories;
        includes.addAll(Arrays.asList(includedFiles));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(excludedFiles));
        ArrayList<String> linksForDeletion = new ArrayList<String>();
        if (!fileSet.isFollowSymlinks()) {
            if (this.verbose && this.log != null) {
                this.log.info((CharSequence)"Adding symbolic link files which were previously excluded to the list being deleted.");
            }
            scanner.setFollowSymlinks(true);
            scanner.scan();
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Originally marked for delete: " + includes));
                this.log.debug((CharSequence)("Marked for preserve (with followSymlinks == false): " + excludes));
            }
            List<String> notSymlinks = Arrays.asList(scanner.getExcludedFiles());
            linksForDeletion.addAll(excludes);
            linksForDeletion.retainAll(notSymlinks);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Symlinks marked for deletion (originally mismarked): " + linksForDeletion));
            }
            excludes.removeAll(notSymlinks);
        }
        for (int i = 0; i < excludedFiles.length; ++i) {
            String path = excludedFiles[i];
            File excluded = new File(path);
            String parentPath = excluded.getParent();
            while (parentPath != null) {
                boolean removed;
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Verifying path: " + parentPath + " is not present; contains file which is excluded."));
                }
                if ((removed = includes.remove(parentPath)) && this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Path: " + parentPath + " was removed from delete list."));
                }
                parentPath = new File(parentPath).getParent();
            }
        }
        includes.addAll(linksForDeletion);
        return includes;
    }

    private void removeDir(File dir, boolean followSymlinks) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(dir, s);
            if (f.isDirectory() && (followSymlinks || !this.isSymlink(f))) {
                this.removeDir(f, followSymlinks);
                continue;
            }
            if (this.delete(f)) continue;
            String message = "Unable to delete file " + f.getAbsolutePath();
            throw new IOException(message);
        }
        if (!this.delete(dir)) {
            String message = "Unable to delete directory " + dir.getAbsolutePath();
            throw new IOException(message);
        }
    }

    private boolean delete(File f) {
        if (!f.delete()) {
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
                return f.delete();
            }
            catch (InterruptedException ex) {
                return f.delete();
            }
        }
        return true;
    }

    private DirectoryScanner scan(FileSet fileSet) {
        File basedir = new File(fileSet.getDirectory());
        if (!basedir.exists()) {
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        String[] includesArray = fileSet.getIncludesArray();
        String[] excludesArray = fileSet.getExcludesArray();
        if (includesArray.length < 1 && excludesArray.length < 1) {
            scanner.setIncludes(new String[]{"**"});
        } else {
            scanner.setIncludes(includesArray);
            scanner.setExcludes(excludesArray);
        }
        scanner.setBasedir(basedir);
        scanner.setFollowSymlinks(fileSet.isFollowSymlinks());
        scanner.scan();
        return scanner;
    }
}

