/*
 * $Id$
 */

package org.apache.maven.shared.model.fileset;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Mapper implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field type
     */
    private String type = "identity";

    /**
     * Field from
     */
    private String from;

    /**
     * Field to
     */
    private String to;

    /**
     * Field classname
     */
    private String classname;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *           Allows specification of a custom mapper
     * implementation. The class must be of type
     *          
     * org.apache.maven.shared.model.fileset.mappers.FileNameMapper,
     * from the artifact
     *           org.apache.maven.shared:file-management.
     *           
     */
    public String getClassname()
    {
        return this.classname;
    } //-- String getClassname() 

    /**
     * Get 
     *               Specifies a type-specific pattern for matching
     * source paths which should be mapped.
     *           
     */
    public String getFrom()
    {
        return this.from;
    } //-- String getFrom() 

    /**
     * Get 
     *           Specifies a type-specific pattern for producing
     * paths based on source paths.
     *           
     */
    public String getTo()
    {
        return this.to;
    } //-- String getTo() 

    /**
     * Get 
     *             
     *             Specifies a built-in mapper implementation.
     *             <br/>
     *             Valid values:
     *             <ul>
     *               <li><b>"flatten"</b> -
     *                   The target file name is identical to the
     * source file name, with all leading
     *                   directory information stripped off. Both
     * to and from will be ignored.
     *               </li>
     *               <li><b>"glob"</b> -
     *                   Both to and from define patterns that may
     * contain at most one *. For each source
     *                   file that matches the from pattern, a
     * target file name will be constructed from
     *                   the to pattern by substituting the * in
     * the to pattern with the text that matches
     *                   the * in the from pattern. Source file
     * names that don't match the from pattern
     *                   will be ignored.
     *               </li>
     *               <li><b>"regexp"</b> -
     *                   Both to and from define regular
     * expressions. If the source file name matches the
     *                   from pattern, the target file name will be
     * constructed from the to pattern, using
     *                   \0 to \9 as back-references for the full
     * match (\0) or the matches of the
     *                   subexpressions in parentheses. Source
     * files not matching the from pattern will be
     *                   ignored.
     *               </li>
     *               <li><b>"merge"</b> -
     *                   The target file name will always be the
     * same, as defined by to. from will be
     *                   ignored.
     *               </li>
     *               <li><b>"package"</b> -
     *                   Sharing the same syntax as the glob
     * mapper, the package mapper replaces directory
     *                   separators found in the matched source
     * pattern with dots in the target pattern
     *                   placeholder.
     *               </li>
     *               <li><b>"unpackage"</b> -
     *                   This mapper is the inverse of the package
     * mapper. It replaces the dots in a
     *                   package name with directory separators.
     * This is useful for matching XML formatter
     *                   results against their JUnit test test
     * cases. The mapper shares the sample syntax
     *                   as the glob mapper.
     *               </li>
     *             </ul>
     *             
     *           
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Set 
     *           Allows specification of a custom mapper
     * implementation. The class must be of type
     *          
     * org.apache.maven.shared.model.fileset.mappers.FileNameMapper,
     * from the artifact
     *           org.apache.maven.shared:file-management.
     *           
     * 
     * @param classname
     */
    public void setClassname(String classname)
    {
        this.classname = classname;
    } //-- void setClassname(String) 

    /**
     * Set 
     *               Specifies a type-specific pattern for matching
     * source paths which should be mapped.
     *           
     * 
     * @param from
     */
    public void setFrom(String from)
    {
        this.from = from;
    } //-- void setFrom(String) 

    /**
     * Set 
     *           Specifies a type-specific pattern for producing
     * paths based on source paths.
     *           
     * 
     * @param to
     */
    public void setTo(String to)
    {
        this.to = to;
    } //-- void setTo(String) 

    /**
     * Set 
     *             
     *             Specifies a built-in mapper implementation.
     *             <br/>
     *             Valid values:
     *             <ul>
     *               <li><b>"flatten"</b> -
     *                   The target file name is identical to the
     * source file name, with all leading
     *                   directory information stripped off. Both
     * to and from will be ignored.
     *               </li>
     *               <li><b>"glob"</b> -
     *                   Both to and from define patterns that may
     * contain at most one *. For each source
     *                   file that matches the from pattern, a
     * target file name will be constructed from
     *                   the to pattern by substituting the * in
     * the to pattern with the text that matches
     *                   the * in the from pattern. Source file
     * names that don't match the from pattern
     *                   will be ignored.
     *               </li>
     *               <li><b>"regexp"</b> -
     *                   Both to and from define regular
     * expressions. If the source file name matches the
     *                   from pattern, the target file name will be
     * constructed from the to pattern, using
     *                   \0 to \9 as back-references for the full
     * match (\0) or the matches of the
     *                   subexpressions in parentheses. Source
     * files not matching the from pattern will be
     *                   ignored.
     *               </li>
     *               <li><b>"merge"</b> -
     *                   The target file name will always be the
     * same, as defined by to. from will be
     *                   ignored.
     *               </li>
     *               <li><b>"package"</b> -
     *                   Sharing the same syntax as the glob
     * mapper, the package mapper replaces directory
     *                   separators found in the matched source
     * pattern with dots in the target pattern
     *                   placeholder.
     *               </li>
     *               <li><b>"unpackage"</b> -
     *                   This mapper is the inverse of the package
     * mapper. It replaces the dots in a
     *                   package name with directory separators.
     * This is useful for matching XML formatter
     *                   results against their JUnit test test
     * cases. The mapper shares the sample syntax
     *                   as the glob mapper.
     *               </li>
     *             </ul>
     *             
     *           
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
