/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.Objects;
import org.apache.maven.project.MavenProject;

final class ArtifactKey {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final int hashCode;

    ArtifactKey(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.hashCode = Objects.hash(groupId, artifactId, version);
    }

    ArtifactKey(MavenProject project) {
        this(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactKey)) {
            return false;
        }
        ArtifactKey that = (ArtifactKey)o;
        return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

