/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.converter.ConverterListener;
import org.apache.maven.model.converter.PomV3ToV4Translator;
import org.apache.maven.model.converter.ProjectConverterException;
import org.apache.maven.model.converter.plugins.PluginConfigurationConverter;
import org.apache.maven.model.converter.relocators.PluginRelocator;
import org.apache.maven.model.converter.relocators.PluginRelocatorManager;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.v3_0_0.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Maven1Converter
extends AbstractLogEnabled {
    private List converters;
    private PluginRelocatorManager pluginRelocatorManager;
    private File basedir;
    private File outputdir;
    private String fileName = "project.xml";
    private List listeners = new ArrayList();

    public void execute() throws ProjectConverterException {
        Model v4Model;
        org.apache.maven.model.v3_0_0.Model v3Model;
        File projectxml = new File(this.basedir, this.fileName);
        if (!projectxml.exists()) {
            throw new ProjectConverterException("Missing " + this.fileName + " in " + this.basedir.getAbsolutePath());
        }
        PomV3ToV4Translator translator = new PomV3ToV4Translator();
        try {
            v3Model = this.loadV3Pom(projectxml);
        }
        catch (Exception e) {
            throw new ProjectConverterException("Exception caught while loading " + this.fileName + ". " + e.getMessage(), e);
        }
        try {
            v4Model = translator.translate(v3Model);
            this.removeDistributionManagementStatus(v4Model);
        }
        catch (Exception e) {
            throw new ProjectConverterException("Exception caught while converting " + this.fileName + ". " + e.getMessage(), e);
        }
        Properties properties = new Properties();
        if (v3Model.getExtend() != null) {
            this.loadProperties(properties, new File(new File(this.basedir, v3Model.getExtend()).getParentFile(), "project.properties"));
        }
        this.loadProperties(properties, new File(this.basedir, "project.properties"));
        Iterator i = this.converters.iterator();
        while (i.hasNext()) {
            PluginConfigurationConverter converter = (PluginConfigurationConverter)i.next();
            converter.convertConfiguration(v4Model, v3Model, properties);
        }
        Collection pluginRelocators = this.pluginRelocatorManager.getPluginRelocators();
        this.sendInfoMessage("There are " + pluginRelocators.size() + " plugin relocators available");
        Iterator iterator = pluginRelocators.iterator();
        while (iterator.hasNext()) {
            PluginRelocator pluginRelocator = (PluginRelocator)iterator.next();
            pluginRelocator.relocate(v4Model);
        }
        try {
            this.writeV4Pom(v4Model);
        }
        catch (IOException e) {
            throw new ProjectConverterException("Failed to write the pom.xml.", e);
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(Properties properties, File propertiesFile) {
        if (propertiesFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propertiesFile);
                properties.load(is);
            }
            catch (IOException e) {
                try {
                    this.sendWarnMessage("Unable to read " + propertiesFile.getAbsolutePath() + ", ignoring.");
                }
                catch (Throwable throwable) {
                    IOUtil.close(is);
                    throw throwable;
                }
                IOUtil.close((InputStream)is);
            }
            IOUtil.close((InputStream)is);
        }
    }

    private org.apache.maven.model.v3_0_0.Model loadV3Pom(File inputFile) throws Exception {
        MavenXpp3Reader v3Reader = new MavenXpp3Reader();
        org.apache.maven.model.v3_0_0.Model model = v3Reader.read((Reader)new FileReader(inputFile));
        SAXReader r = new SAXReader();
        Document d = r.read((Reader)new FileReader(inputFile));
        Element root = d.getRootElement();
        Element idElement = root.element("id");
        String id = null;
        if (idElement != null) {
            id = idElement.getText();
        }
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        if (!this.isEmpty(id)) {
            int i = id.indexOf("+");
            int j = id.indexOf(":");
            if (i > 0) {
                model.setGroupId(id.substring(0, i));
                model.setArtifactId(id.replace('+', '-'));
            } else if (j > 0) {
                model.setGroupId(id.substring(0, j));
                model.setArtifactId(id.substring(j + 1));
            } else {
                model.setGroupId(id);
                model.setArtifactId(id);
            }
            if (!this.isEmpty(groupId)) {
                this.sendWarnMessage("Both <id> and <groupId> is set, using <groupId>.");
                model.setGroupId(groupId);
            }
            if (!this.isEmpty(artifactId)) {
                this.sendWarnMessage("Both <id> and <artifactId> is set, using <artifactId>.");
                model.setArtifactId(artifactId);
            }
        }
        return model;
    }

    private void removeDistributionManagementStatus(Model v4Model) {
        if (v4Model.getDistributionManagement() != null && "converted".equals(v4Model.getDistributionManagement().getStatus())) {
            v4Model.getDistributionManagement().setStatus(null);
        }
    }

    private void writeV4Pom(Model v4Model) throws ProjectConverterException, IOException {
        if (this.outputdir == null) {
            this.outputdir = this.basedir;
        }
        if (!this.outputdir.exists() && !this.outputdir.mkdirs()) {
            throw new IOException("Failed to create directory " + this.outputdir);
        }
        File pomxml = new File(this.outputdir, "pom.xml");
        if (pomxml.exists()) {
            this.sendWarnMessage("pom.xml in " + this.outputdir.getAbsolutePath() + " already exists, overwriting");
        }
        MavenXpp3Writer v4Writer = new MavenXpp3Writer();
        this.sendInfoMessage("Writing new pom to: " + pomxml.getAbsolutePath());
        FileWriter output = null;
        try {
            output = new FileWriter(pomxml);
            v4Writer.write((Writer)output, v4Model);
            ((Writer)output).close();
        }
        catch (IOException e) {
            try {
                throw new ProjectConverterException("Unable to write pom.xml. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(output);
                throw throwable;
            }
        }
        IOUtil.close((Writer)output);
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getProjectFileName() {
        return this.fileName;
    }

    public void setProjectFileName(String projectFileName) {
        this.fileName = projectFileName;
    }

    public void setProjectFile(File projectFile) {
        if (projectFile != null) {
            this.basedir = projectFile.getParentFile();
            this.fileName = projectFile.getName();
        }
    }

    public File getOutputdir() {
        return this.outputdir;
    }

    public void setOutputdir(File outputdir) {
        this.outputdir = outputdir;
    }

    public void addListener(ConverterListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void sendInfoMessage(String message) {
        this.getLogger().info(message);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConverterListener listener = (ConverterListener)i.next();
            listener.info(message);
        }
    }

    private void sendWarnMessage(String message) {
        this.getLogger().warn(message);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConverterListener listener = (ConverterListener)i.next();
            listener.warn(message);
        }
    }
}

