/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.apache.maven.model.converter.ModelConverter;
import org.apache.maven.model.converter.PomTranslationException;
import org.apache.maven.model.v3_0_0.Repository;
import org.apache.maven.model.v3_0_0.UnitTest;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PomV3ToV4Translator
implements ModelConverter {
    private transient List discoveredPlugins = new ArrayList();
    private List warnings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model translate(org.apache.maven.model.v3_0_0.Model v3Model) throws PomTranslationException {
        this.warnings = new ArrayList();
        try {
            String version;
            String groupId = this.format(v3Model.getGroupId());
            String artifactId = this.format(v3Model.getArtifactId());
            String id = v3Model.getId();
            if (StringUtils.isNotEmpty((String)id)) {
                if (StringUtils.isEmpty((String)groupId)) {
                    int plusIdx = id.indexOf("+");
                    groupId = plusIdx > -1 ? id.substring(0, plusIdx) : id;
                }
                if (StringUtils.isEmpty((String)artifactId)) {
                    artifactId = this.format(id);
                }
            }
            if ((version = this.format(v3Model.getCurrentVersion())) == null) {
                version = this.format(v3Model.getVersion());
            }
            PomKey pomKey = new PomKey(groupId, artifactId, version);
            this.warnOfUnsupportedMainModelElements(v3Model);
            Model model = new Model();
            model.setArtifactId(artifactId);
            model.setDependencies(this.translateDependencies(v3Model.getDependencies()));
            model.setBuild(this.translateBuild(v3Model.getBuild()));
            model.setCiManagement(this.translateCiManagementInfo(v3Model.getBuild()));
            model.setContributors(this.translateContributors(v3Model.getContributors()));
            model.setDescription(v3Model.getDescription());
            model.setDevelopers(this.translateDevelopers(v3Model.getDevelopers()));
            model.setDistributionManagement(this.translateDistributionManagement(pomKey, v3Model));
            model.setGroupId(groupId);
            model.setInceptionYear(v3Model.getInceptionYear());
            model.setIssueManagement(this.translateIssueManagement(v3Model));
            model.setLicenses(this.translateLicenses(v3Model.getLicenses()));
            model.setMailingLists(this.translateMailingLists(v3Model.getMailingLists()));
            model.setModelVersion("4.0.0");
            model.setName(v3Model.getName());
            model.setOrganization(this.translateOrganization(v3Model.getOrganization()));
            model.setPackaging("jar");
            model.setScm(this.translateScm(v3Model));
            model.setUrl(v3Model.getUrl());
            model.setVersion(version);
            Model model2 = model;
            return model2;
        }
        finally {
            this.discoveredPlugins.clear();
        }
    }

    private String format(String source) {
        return source == null ? null : source.replace('+', '-');
    }

    private CiManagement translateCiManagementInfo(org.apache.maven.model.v3_0_0.Build v3Build) {
        String nagEmailAddress;
        CiManagement ciMgmt = null;
        if (v3Build != null && StringUtils.isNotEmpty((String)(nagEmailAddress = v3Build.getNagEmailAddress()))) {
            Notifier notifier = new Notifier();
            notifier.setType("mail");
            notifier.addConfiguration("address", nagEmailAddress);
            ciMgmt = new CiManagement();
            ciMgmt.addNotifier(notifier);
        }
        return ciMgmt;
    }

    private void warnOfUnsupportedMainModelElements(org.apache.maven.model.v3_0_0.Model v3Model) {
        Properties v3ModelProperties;
        if (StringUtils.isNotEmpty((String)v3Model.getExtend())) {
            this.warnings.add("Ignoring non-portable parent declaration: " + v3Model.getExtend());
        }
        if (StringUtils.isNotEmpty((String)v3Model.getGumpRepositoryId())) {
            this.warnings.add("Ignoring gump repository id: '" + v3Model.getGumpRepositoryId() + "'. This is not supported in v4 POMs.");
        }
        if (this.notEmpty(v3Model.getVersions())) {
            this.warnings.add("Ignoring <versions/> section. This is not supported in v4 POMs.");
        }
        if (this.notEmpty(v3Model.getBranches())) {
            this.warnings.add("Ignoring <branches/> section. This is not supported in v4 POMs.");
        }
        if ((v3ModelProperties = v3Model.getProperties()) != null && !((Hashtable)v3ModelProperties).isEmpty()) {
            this.warnings.add("Ignoring <properties/> section. It is not supported in v4 POMs.");
        }
        if (StringUtils.isNotEmpty((String)v3Model.getPackage())) {
            this.warnings.add("Ignoring <package/>. It is not supported in v4 POMs.");
        }
        if (this.notEmpty(v3Model.getPackageGroups())) {
            this.warnings.add("Ignoring <packageGroups/> section. It is not supported in v4 POMs.");
        }
        if (StringUtils.isNotEmpty((String)v3Model.getLogo())) {
            this.warnings.add("Ignoring <logo/> for project. It is not supported in v4 POMs.");
        }
        if (StringUtils.isNotEmpty((String)v3Model.getShortDescription())) {
            this.warnings.add("Ignoring <shortDescription/>. It is not supported in v4 POMs.");
        }
    }

    private Scm translateScm(org.apache.maven.model.v3_0_0.Model v3Model) {
        Scm scm = null;
        Repository repo = v3Model.getRepository();
        if (repo != null) {
            scm = new Scm();
            scm.setConnection(repo.getConnection());
            scm.setDeveloperConnection(repo.getDeveloperConnection());
            scm.setUrl(repo.getUrl());
        }
        return scm;
    }

    private Organization translateOrganization(org.apache.maven.model.v3_0_0.Organization v3Organization) {
        Organization organization = null;
        if (v3Organization != null) {
            organization = new Organization();
            organization.setName(v3Organization.getName());
            organization.setUrl(v3Organization.getUrl());
            if (StringUtils.isNotEmpty((String)v3Organization.getLogo())) {
                this.warnings.add("Ignoring <organization><logo/></organization>. It is not supported in v4 POMs.");
            }
        }
        return organization;
    }

    private List translateMailingLists(List v3MailingLists) {
        ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
        if (this.notEmpty(v3MailingLists)) {
            Iterator it = v3MailingLists.iterator();
            while (it.hasNext()) {
                org.apache.maven.model.v3_0_0.MailingList v3List = (org.apache.maven.model.v3_0_0.MailingList)it.next();
                MailingList list = new MailingList();
                list.setArchive(v3List.getArchive());
                list.setName(v3List.getName());
                list.setSubscribe(v3List.getSubscribe());
                list.setUnsubscribe(v3List.getUnsubscribe());
                mailingLists.add(list);
            }
        }
        return mailingLists;
    }

    private List translateLicenses(List v3Licenses) {
        ArrayList<License> licenses = new ArrayList<License>();
        if (this.notEmpty(v3Licenses)) {
            Iterator it = v3Licenses.iterator();
            while (it.hasNext()) {
                org.apache.maven.model.v3_0_0.License v3License = (org.apache.maven.model.v3_0_0.License)it.next();
                License license = new License();
                license.setComments(v3License.getComments());
                license.setName(v3License.getName());
                license.setUrl(v3License.getUrl());
                licenses.add(license);
            }
        }
        return licenses;
    }

    private IssueManagement translateIssueManagement(org.apache.maven.model.v3_0_0.Model v3Model) {
        IssueManagement issueMgmt = null;
        String issueTrackingUrl = v3Model.getIssueTrackingUrl();
        if (StringUtils.isNotEmpty((String)issueTrackingUrl)) {
            issueMgmt = new IssueManagement();
            issueMgmt.setUrl(issueTrackingUrl);
        }
        return issueMgmt;
    }

    private DistributionManagement translateDistributionManagement(PomKey pomKey, org.apache.maven.model.v3_0_0.Model v3Model) throws PomTranslationException {
        DistributionManagement distributionManagement = new DistributionManagement();
        Site site = null;
        String siteAddress = v3Model.getSiteAddress();
        String siteDirectory = v3Model.getSiteDirectory();
        if (StringUtils.isEmpty((String)siteAddress)) {
            if (!StringUtils.isEmpty((String)siteDirectory)) {
                site = new Site();
                site.setId("default");
                site.setName("Default Site");
                site.setUrl("file://" + siteDirectory);
            }
        } else {
            if (StringUtils.isEmpty((String)siteDirectory)) {
                throw new PomTranslationException(pomKey.groupId(), pomKey.artifactId(), pomKey.version(), "Missing 'siteDirectory': Both siteAddress and siteDirectory must be set at the same time.");
            }
            site = new Site();
            site.setId("default");
            site.setName("Default Site");
            site.setUrl("scp://" + siteAddress + "/" + siteDirectory);
        }
        distributionManagement.setSite(site);
        String distributionSite = v3Model.getDistributionSite();
        String distributionDirectory = v3Model.getDistributionDirectory();
        DeploymentRepository repository = null;
        if (StringUtils.isEmpty((String)distributionSite)) {
            if (!StringUtils.isEmpty((String)distributionDirectory)) {
                repository = new DeploymentRepository();
                repository.setId("default");
                repository.setName("Default Repository");
                repository.setUrl("file://" + distributionDirectory);
            }
        } else {
            if (StringUtils.isEmpty((String)distributionDirectory)) {
                throw new PomTranslationException(pomKey.groupId(), pomKey.artifactId(), pomKey.version(), "Missing 'distributionDirectory': must be set is 'distributionSite' is set.");
            }
            repository = new DeploymentRepository();
            repository.setId("default");
            repository.setName("Default Repository");
            repository.setUrl(distributionSite + "/" + distributionDirectory);
        }
        distributionManagement.setRepository(repository);
        distributionManagement.setStatus("converted");
        if (site == null && repository == null) {
            return null;
        }
        return distributionManagement;
    }

    private List translateDevelopers(List v3Developers) {
        ArrayList<Developer> developers = new ArrayList<Developer>();
        if (this.notEmpty(v3Developers)) {
            Iterator it = v3Developers.iterator();
            while (it.hasNext()) {
                org.apache.maven.model.v3_0_0.Developer v3Developer = (org.apache.maven.model.v3_0_0.Developer)it.next();
                Developer developer = new Developer();
                developer.setEmail(v3Developer.getEmail());
                developer.setId(v3Developer.getId());
                developer.setName(v3Developer.getName());
                developer.setOrganization(v3Developer.getOrganization());
                developer.setRoles(v3Developer.getRoles());
                developer.setTimezone(v3Developer.getTimezone());
                developer.setUrl(v3Developer.getUrl());
                developers.add(developer);
            }
        }
        return developers;
    }

    private List translateDependencies(List v3Deps) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        if (this.notEmpty(v3Deps)) {
            boolean isJunitPresent = false;
            Iterator it = v3Deps.iterator();
            while (it.hasNext()) {
                String optional;
                String type;
                org.apache.maven.model.v3_0_0.Dependency v3Dep = (org.apache.maven.model.v3_0_0.Dependency)it.next();
                String groupId = this.format(v3Dep.getGroupId());
                String artifactId = this.format(v3Dep.getArtifactId());
                String id = v3Dep.getId();
                if (StringUtils.isNotEmpty((String)id)) {
                    if (StringUtils.isEmpty((String)groupId)) {
                        int plusIdx = id.indexOf("+");
                        groupId = plusIdx > -1 ? id.substring(0, plusIdx) : id;
                    }
                    if (StringUtils.isEmpty((String)artifactId)) {
                        artifactId = this.format(id);
                    }
                }
                if ("junit".equals(groupId) && "junit".equals(artifactId)) {
                    isJunitPresent = true;
                }
                if ("plugin".equals(type = v3Dep.getType())) {
                    if ("maven".equals(groupId)) {
                        groupId = "org.apache.maven.plugins";
                    }
                    Plugin plugin = new Plugin();
                    plugin.setGroupId(groupId);
                    plugin.setArtifactId(artifactId);
                    plugin.setVersion(this.format(v3Dep.getVersion()));
                    Xpp3Dom config = new Xpp3Dom("configuration");
                    Properties props = v3Dep.getProperties();
                    if (!((Hashtable)props).isEmpty()) {
                        Iterator propertyIterator = ((Hashtable)props).keySet().iterator();
                        while (propertyIterator.hasNext()) {
                            String key = (String)propertyIterator.next();
                            String value = props.getProperty(key);
                            Xpp3Dom child = new Xpp3Dom(key);
                            child.setValue(value);
                            config.addChild(child);
                        }
                        plugin.setConfiguration((Object)config);
                    }
                    this.discoveredPlugins.add(plugin);
                    continue;
                }
                Dependency dep = new Dependency();
                dep.setGroupId(groupId);
                dep.setArtifactId(artifactId);
                dep.setVersion(v3Dep.getVersion());
                dep.setType(v3Dep.getType());
                String scope = v3Dep.getProperty("scope");
                if (StringUtils.isNotEmpty((String)scope)) {
                    dep.setScope(scope);
                }
                if (StringUtils.isNotEmpty((String)(optional = v3Dep.getProperty("optional")))) {
                    dep.setOptional(Boolean.valueOf(optional).booleanValue());
                }
                deps.add(dep);
            }
            if (!isJunitPresent) {
                Dependency junitDep = new Dependency();
                junitDep.setGroupId("junit");
                junitDep.setArtifactId("junit");
                junitDep.setVersion("3.8.2");
                junitDep.setScope("test");
                deps.add(junitDep);
            }
        }
        return deps;
    }

    private List translateContributors(List v3Contributors) {
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        if (this.notEmpty(v3Contributors)) {
            Iterator it = v3Contributors.iterator();
            while (it.hasNext()) {
                org.apache.maven.model.v3_0_0.Contributor v3Contributor = (org.apache.maven.model.v3_0_0.Contributor)it.next();
                Contributor contributor = new Contributor();
                contributor.setEmail(v3Contributor.getEmail());
                contributor.setName(v3Contributor.getName());
                contributor.setOrganization(v3Contributor.getOrganization());
                contributor.setRoles(v3Contributor.getRoles());
                contributor.setTimezone(v3Contributor.getTimezone());
                contributor.setUrl(v3Contributor.getUrl());
                contributors.add(contributor);
            }
        }
        return contributors;
    }

    private Build translateBuild(org.apache.maven.model.v3_0_0.Build v3Build) {
        Build build = null;
        if (v3Build != null) {
            build = new Build();
            this.warnOfUnsupportedBuildElements(v3Build);
            build.setSourceDirectory(v3Build.getSourceDirectory());
            build.setTestSourceDirectory(v3Build.getUnitTestSourceDirectory());
            build.setResources(this.translateResources(v3Build.getResources()));
            UnitTest unitTest = v3Build.getUnitTest();
            if (unitTest != null) {
                build.setTestResources(this.translateResources(unitTest.getResources()));
                List testIncludes = unitTest.getIncludes();
                ArrayList testExcludes = new ArrayList(unitTest.getExcludes());
                if (this.notEmpty(testIncludes) || this.notEmpty(testExcludes)) {
                    Iterator it;
                    Plugin plugin = new Plugin();
                    plugin.setGroupId("org.apache.maven.plugins");
                    plugin.setArtifactId("maven-surefire-plugin");
                    Xpp3Dom config = new Xpp3Dom("configuration");
                    if (this.notEmpty(testIncludes)) {
                        Xpp3Dom includes = new Xpp3Dom("includes");
                        it = testIncludes.iterator();
                        while (it.hasNext()) {
                            String includePattern = (String)it.next();
                            Xpp3Dom include = new Xpp3Dom("include");
                            include.setValue(includePattern);
                            includes.addChild(include);
                        }
                        config.addChild(includes);
                    }
                    if (this.notEmpty(testExcludes)) {
                        Xpp3Dom excludes = new Xpp3Dom("excludes");
                        it = testExcludes.iterator();
                        while (it.hasNext()) {
                            String excludePattern = (String)it.next();
                            Xpp3Dom exclude = new Xpp3Dom("exclude");
                            exclude.setValue(excludePattern);
                            excludes.addChild(exclude);
                        }
                        config.addChild(excludes);
                    }
                    if (config.getChildCount() > 0) {
                        plugin.setConfiguration((Object)config);
                    }
                    build.addPlugin(plugin);
                }
            }
        }
        if (!this.discoveredPlugins.isEmpty()) {
            if (build == null) {
                build = new Build();
            }
            Iterator it = this.discoveredPlugins.iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                build.addPlugin(plugin);
            }
        }
        return build;
    }

    private void warnOfUnsupportedBuildElements(org.apache.maven.model.v3_0_0.Build v3Build) {
        if (this.notEmpty(v3Build.getSourceModifications())) {
            this.warnings.add("Ignoring <sourceModifications/> section. It is not supported in v4 POMs.");
        }
        if (StringUtils.isNotEmpty((String)v3Build.getAspectSourceDirectory())) {
            this.warnings.add("Ignoring <aspectSourceDirectory/>. It is not supported in v4 POMs.");
        }
        if (StringUtils.isNotEmpty((String)v3Build.getIntegrationUnitTestSourceDirectory())) {
            this.warnings.add("Ignoring <integrationUnitTestSourceDirectory/>. It is not supported in v4 POMs.");
        }
    }

    private List translateResources(List v3Resources) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.notEmpty(v3Resources)) {
            Iterator it = v3Resources.iterator();
            while (it.hasNext()) {
                org.apache.maven.model.v3_0_0.Resource v3Resource = (org.apache.maven.model.v3_0_0.Resource)it.next();
                Resource resource = new Resource();
                if (v3Resource.getDirectory() == null) {
                    resource.setDirectory(".");
                } else {
                    resource.setDirectory(v3Resource.getDirectory());
                }
                ArrayList excludes = new ArrayList(v3Resource.getExcludes());
                resource.setExcludes(excludes);
                resource.setIncludes(v3Resource.getIncludes());
                resource.setTargetPath(v3Resource.getTargetPath());
                resources.add(resource);
            }
        }
        return resources;
    }

    private boolean notEmpty(List test) {
        return test != null && !test.isEmpty();
    }

    public void validateV4Basics(Model model, String groupId, String artifactId, String version, String packaging) {
        if (StringUtils.isEmpty((String)model.getModelVersion())) {
            model.setModelVersion("4.0.0");
        }
        if (StringUtils.isEmpty((String)model.getGroupId())) {
            this.warnings.add("Setting groupId on model using artifact information.");
            model.setGroupId(groupId);
        }
        if (StringUtils.isEmpty((String)model.getArtifactId())) {
            this.warnings.add("Setting artifactId on model using artifact information.");
            model.setArtifactId(artifactId);
        }
        if (StringUtils.isEmpty((String)model.getVersion())) {
            this.warnings.add("Setting version on model using artifact information.");
            model.setVersion(version);
        }
        if (StringUtils.isEmpty((String)model.getPackaging())) {
            this.warnings.add("Setting packaging on model using artifact type information.");
            model.setPackaging(packaging);
        }
    }

    public List getWarnings() {
        return this.warnings;
    }

    private static class PomKey {
        private final String groupId;
        private final String artifactId;
        private final String version;

        PomKey(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String groupId() {
            return this.groupId;
        }

        public String artifactId() {
            return this.artifactId;
        }

        public String version() {
            return this.version;
        }
    }
}

