/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.converter.ArtifactPomRewriter;
import org.apache.maven.model.converter.ModelConverter;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.v3_0_0.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class V3PomRewriter
implements ArtifactPomRewriter {
    private ModelConverter translator;

    public void rewrite(Reader from, Writer to, boolean reportOnly, String groupId, String artifactId, String version, String packaging) throws Exception {
        Model v4Model;
        if (from != null) {
            MavenXpp3Reader v3Reader = new MavenXpp3Reader();
            StringWriter w = new StringWriter();
            IOUtil.copy((Reader)from, (Writer)w);
            String content = StringUtils.replace((String)w.toString(), (String)"${pom.currentVersion}", (String)"${project.version}");
            org.apache.maven.model.v3_0_0.Model v3Model = v3Reader.read((Reader)new StringReader(content));
            v4Model = this.translator.translate(v3Model);
        } else {
            v4Model = new Model();
        }
        if (v4Model != null) {
            this.translator.validateV4Basics(v4Model, groupId, artifactId, version, packaging);
            if (!reportOnly) {
                MavenXpp3Writer v4Writer = new MavenXpp3Writer();
                v4Writer.write(to, v4Model);
            }
        }
    }

    public List getWarnings() {
        return this.translator.getWarnings();
    }
}

