/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter.plugins;

import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.model.converter.ProjectConverterException;
import org.apache.maven.model.converter.plugins.AbstractPluginConfigurationConverter;
import org.apache.maven.model.v3_0_0.Model;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PCCPmd
extends AbstractPluginConfigurationConverter {
    public String getArtifactId() {
        return "maven-pmd-plugin";
    }

    public String getType() {
        return "report plugin";
    }

    protected void buildConfiguration(Xpp3Dom configuration, Model v3Model, Properties projectProperties) throws ProjectConverterException {
        StringTokenizer tokenizer;
        this.addConfigurationChild(configuration, projectProperties, "maven.pmd.excludes", "excludes");
        this.addConfigurationChild(configuration, projectProperties, "maven.pmd.failonruleviolation", "failOnViolation");
        this.addConfigurationChild(configuration, projectProperties, "maven.pmd.cpd.minimumtokencount", "minimumTokens");
        String rulesetfiles = projectProperties.getProperty("maven.pmd.rulesetfiles");
        if (rulesetfiles != null && (tokenizer = new StringTokenizer(rulesetfiles, ",")).hasMoreTokens()) {
            Xpp3Dom rulesets = new Xpp3Dom("rulesets");
            while (tokenizer.hasMoreTokens()) {
                this.addConfigurationChild(rulesets, "ruleset", this.translate(tokenizer.nextToken()));
            }
            if (rulesets.getChildCount() > 0) {
                configuration.addChild(rulesets);
            }
        }
        this.addConfigurationChild(configuration, projectProperties, "maven.pmd.targetjdk", "targetJdk");
    }

    private String translate(String mavenOneRuleset) {
        if (mavenOneRuleset != null && mavenOneRuleset.startsWith("rulesets/")) {
            return "/" + mavenOneRuleset;
        }
        return mavenOneRuleset;
    }
}

