/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter.plugins;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.model.converter.ProjectConverterException;
import org.apache.maven.model.converter.plugins.AbstractPluginConfigurationConverter;
import org.apache.maven.model.converter.plugins.PropertyUtils;
import org.apache.maven.model.v3_0_0.Model;
import org.apache.maven.model.v3_0_0.UnitTest;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PCCSurefire
extends AbstractPluginConfigurationConverter {
    public String getArtifactId() {
        return "maven-surefire-plugin";
    }

    public String getType() {
        return "build plugin";
    }

    protected void buildConfiguration(Xpp3Dom configuration, Model v3Model, Properties projectProperties) throws ProjectConverterException {
        StringTokenizer tokenizer;
        this.addConfigurationChild(configuration, projectProperties, "maven.junit.jvmargs", "argLine");
        String forkMode = projectProperties.getProperty("maven.junit.forkmode");
        if (forkMode == null) {
            boolean useFork;
            String fork = projectProperties.getProperty("maven.junit.fork");
            if (fork != null && (useFork = Boolean.valueOf(PropertyUtils.convertYesNoToBoolean(fork)).booleanValue())) {
                this.addConfigurationChild(configuration, "forkMode", "once");
            }
        } else {
            this.addConfigurationChild(configuration, projectProperties, "maven.junit.forkmode", "forkMode");
        }
        this.addConfigurationChild(configuration, projectProperties, "maven.junit.jvm", "jvm");
        this.addConfigurationChild(configuration, projectProperties, "maven.junit.printSummary", "printSummary");
        this.addConfigurationChild(configuration, projectProperties, "maven.junit.format", "reportFormat");
        this.addConfigurationChild(configuration, projectProperties, "maven.test.skip", "skip");
        String sysproperties = projectProperties.getProperty("maven.junit.sysproperties");
        if (sysproperties != null && (tokenizer = new StringTokenizer(sysproperties)).hasMoreTokens()) {
            Xpp3Dom systemProperties = new Xpp3Dom("systemProperties");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                String value = projectProperties.getProperty(name);
                this.addConfigurationChild(systemProperties, name, value);
            }
            if (systemProperties.getChildCount() > 0) {
                configuration.addChild(systemProperties);
            }
        }
        this.addConfigurationChild(configuration, projectProperties, "maven.test.failure.ignore", "testFailureIgnore");
        this.addConfigurationChild(configuration, projectProperties, "maven.junit.usefile", "useFile");
        if (v3Model.getBuild() != null && v3Model.getBuild().getUnitTest() != null) {
            List includes;
            UnitTest v3UnitTest = v3Model.getBuild().getUnitTest();
            List excludes = v3UnitTest.getExcludes();
            if (excludes != null && excludes.size() > 0) {
                Xpp3Dom excludesConf = new Xpp3Dom("excludes");
                Iterator iter = excludes.iterator();
                while (iter.hasNext()) {
                    this.addConfigurationChild(excludesConf, "exclude", (String)iter.next());
                }
                configuration.addChild(excludesConf);
            }
            if ((includes = v3UnitTest.getIncludes()) != null && includes.size() > 0) {
                Xpp3Dom includesConf = new Xpp3Dom("includes");
                Iterator iter = includes.iterator();
                while (iter.hasNext()) {
                    this.addConfigurationChild(includesConf, "include", (String)iter.next());
                }
                configuration.addChild(includesConf);
            }
        }
    }
}

