/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter.relocators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.converter.ConverterListener;
import org.apache.maven.model.converter.ModelUtils;
import org.apache.maven.model.converter.relocators.PluginRelocator;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractPluginRelocator
extends AbstractLogEnabled
implements PluginRelocator {
    private List listeners = new ArrayList();

    public abstract String getNewArtifactId();

    public abstract String getNewGroupId();

    public abstract String getOldArtifactId();

    public String getOldGroupId() {
        return "org.apache.maven.plugins";
    }

    public void relocate(Model v4Model) {
        ReportPlugin oldReportPlugin;
        Plugin oldBuildPlugin = ModelUtils.findBuildPlugin(v4Model, this.getOldGroupId(), this.getOldArtifactId());
        if (oldBuildPlugin != null) {
            if (this.getNewArtifactId() == null && this.getNewGroupId() == null) {
                v4Model.getBuild().getPlugins().remove(oldBuildPlugin);
                this.sendInfoMessage("Removing build plugin " + this.getOldGroupId() + ":" + this.getOldArtifactId());
            } else {
                Plugin newPlugin = ModelUtils.findBuildPlugin(v4Model, this.getNewGroupId(), this.getNewArtifactId());
                if (newPlugin == null) {
                    oldBuildPlugin.setArtifactId(this.getNewArtifactId());
                    oldBuildPlugin.setGroupId(this.getNewGroupId());
                    this.sendInfoMessage("Relocating build plugin " + this.getOldGroupId() + ":" + this.getOldArtifactId());
                } else {
                    v4Model.getBuild().getPlugins().remove(oldBuildPlugin);
                    this.sendInfoMessage("Removing old build plugin " + this.getOldGroupId() + ":" + this.getOldArtifactId() + " because the new one already exist");
                }
            }
        }
        if ((oldReportPlugin = ModelUtils.findReportPlugin(v4Model, this.getOldGroupId(), this.getOldArtifactId())) != null) {
            if (this.getNewArtifactId() == null && this.getNewGroupId() == null) {
                v4Model.getReporting().getPlugins().remove(oldReportPlugin);
                this.sendInfoMessage("Removing report plugin " + this.getOldGroupId() + ":" + this.getOldArtifactId());
            } else {
                ReportPlugin newPlugin = ModelUtils.findReportPlugin(v4Model, this.getNewGroupId(), this.getNewArtifactId());
                if (newPlugin == null) {
                    oldReportPlugin.setArtifactId(this.getNewArtifactId());
                    oldReportPlugin.setGroupId(this.getNewGroupId());
                    this.sendInfoMessage("Relocating report plugin " + this.getOldGroupId() + ":" + this.getOldArtifactId());
                } else {
                    v4Model.getReporting().getPlugins().remove(oldReportPlugin);
                    this.sendInfoMessage("Removing old report plugin " + this.getOldGroupId() + ":" + this.getOldArtifactId() + " because the new one already exist");
                }
            }
        }
    }

    public void addListener(ConverterListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addListeners(List listeners) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            ConverterListener listener = (ConverterListener)i.next();
            this.addListener(listener);
        }
    }

    private void sendInfoMessage(String message) {
        this.getLogger().info(message);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConverterListener listener = (ConverterListener)i.next();
            listener.info(message);
        }
    }
}

