/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter.plugins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.converter.ConverterListener;
import org.apache.maven.model.converter.ModelUtils;
import org.apache.maven.model.converter.ProjectConverterException;
import org.apache.maven.model.converter.plugins.PluginConfigurationConverter;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractPluginConfigurationConverter
extends AbstractLogEnabled
implements PluginConfigurationConverter {
    public static final String TYPE_BUILD_PLUGIN = "build plugin";
    public static final String TYPE_REPORT_PLUGIN = "report plugin";
    private List listeners = new ArrayList();

    public abstract String getArtifactId();

    public String getGroupId() {
        return "org.apache.maven.plugins";
    }

    public abstract String getType();

    public void addListeners(List listeners) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            ConverterListener listener = (ConverterListener)i.next();
            this.addListener(listener);
        }
    }

    public void addListener(ConverterListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void addConfigurationChild(Xpp3Dom configuration, Properties projectProperties, String mavenOneProperty, String mavenTwoElement) {
        String value = projectProperties.getProperty(mavenOneProperty);
        this.addConfigurationChild(configuration, mavenTwoElement, value);
    }

    protected void addConfigurationChild(Xpp3Dom configuration, String mavenTwoElement, String value) {
        if (value != null) {
            Xpp3Dom child = new Xpp3Dom(mavenTwoElement);
            child.setValue(value);
            configuration.addChild(child);
        }
    }

    public void convertConfiguration(Model v4Model, org.apache.maven.model.v3_0_0.Model v3Model, Properties projectProperties) throws ProjectConverterException {
        boolean addPlugin = false;
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        this.buildConfiguration(configuration, v3Model, projectProperties);
        if (configuration.getChildCount() > 0) {
            if (TYPE_BUILD_PLUGIN.equals(this.getType())) {
                Plugin plugin = ModelUtils.findBuildPlugin(v4Model, this.getGroupId(), this.getArtifactId());
                if (plugin == null) {
                    addPlugin = true;
                    plugin = new Plugin();
                    plugin.setGroupId(this.getGroupId());
                    plugin.setArtifactId(this.getArtifactId());
                }
                plugin.setConfiguration((Object)configuration);
                if (addPlugin) {
                    if (v4Model.getBuild() == null) {
                        v4Model.setBuild(new Build());
                    }
                    v4Model.getBuild().addPlugin(plugin);
                    this.sendInfoMessage("Adding plugin " + plugin.getGroupId() + ":" + plugin.getArtifactId());
                    this.fireAddPluginEvent(plugin);
                }
            } else if (TYPE_REPORT_PLUGIN.equals(this.getType())) {
                ReportPlugin plugin = ModelUtils.findReportPlugin(v4Model, this.getGroupId(), this.getArtifactId());
                if (plugin == null) {
                    addPlugin = true;
                    plugin = new ReportPlugin();
                    plugin.setGroupId(this.getGroupId());
                    plugin.setArtifactId(this.getArtifactId());
                }
                plugin.setConfiguration((Object)configuration);
                if (addPlugin) {
                    if (v4Model.getReporting() == null) {
                        v4Model.setReporting(new Reporting());
                    }
                    v4Model.getReporting().addPlugin(plugin);
                    this.sendInfoMessage("Adding report " + plugin.getGroupId() + ":" + plugin.getArtifactId());
                    this.fireAddReportEvent(plugin);
                }
            }
        }
    }

    protected abstract void buildConfiguration(Xpp3Dom var1, org.apache.maven.model.v3_0_0.Model var2, Properties var3) throws ProjectConverterException;

    private void sendInfoMessage(String message) {
        this.getLogger().info(message);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConverterListener listener = (ConverterListener)i.next();
            listener.info(message);
        }
    }

    private void fireAddPluginEvent(Plugin plugin) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConverterListener listener = (ConverterListener)i.next();
            listener.addPluginEvent(plugin.getGroupId(), plugin.getArtifactId());
        }
    }

    private void fireAddReportEvent(ReportPlugin plugin) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConverterListener listener = (ConverterListener)i.next();
            listener.addReportEvent(plugin.getGroupId(), plugin.getArtifactId());
        }
    }
}

