/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter.plugins;

import java.util.Properties;
import org.apache.maven.model.converter.ProjectConverterException;
import org.apache.maven.model.converter.plugins.AbstractPluginConfigurationConverter;
import org.apache.maven.model.v3_0_0.Model;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PCCCheckstyle
extends AbstractPluginConfigurationConverter {
    public String getArtifactId() {
        return "maven-checkstyle-plugin";
    }

    public String getType() {
        return "report plugin";
    }

    protected void buildConfiguration(Xpp3Dom configuration, Model v3Model, Properties projectProperties) throws ProjectConverterException {
        this.addConfigurationChild(configuration, projectProperties, "maven.checkstyle.cache.file", "cacheFile");
        String format = projectProperties.getProperty("maven.checkstyle.format");
        if (format != null) {
            String mavenTwoformat = null;
            if (format.equals("avalon")) {
                mavenTwoformat = "config/avalon_checks.xml";
            } else if (format.equals("turbine")) {
                mavenTwoformat = "config/turbine_checks.xml";
            } else if (format.equals("sun")) {
                mavenTwoformat = "config/sun_checks.xml";
            }
            if (mavenTwoformat != null) {
                this.addConfigurationChild(configuration, "configLocation", mavenTwoformat);
            }
        } else {
            String propertiesURL = projectProperties.getProperty("maven.checkstyle.propertiesURL");
            if (propertiesURL != null) {
                this.addConfigurationChild(configuration, "configLocation", propertiesURL);
            } else {
                this.addConfigurationChild(configuration, projectProperties, "maven.checkstyle.properties", "configLocation");
            }
        }
        this.addConfigurationChild(configuration, projectProperties, "maven.checkstyle.excludes", "excludes");
        this.addConfigurationChild(configuration, projectProperties, "maven.checkstyle.fail.on.violation", "failsOnError");
        this.addConfigurationChild(configuration, projectProperties, "maven.checkstyle.header.file", "headerLocation");
        this.addConfigurationChild(configuration, projectProperties, "maven.checkstyle.includes", "includes");
        String outputText = projectProperties.getProperty("maven.checkstyle.output.txt");
        if (outputText != null) {
            this.addConfigurationChild(configuration, "outputFile", outputText);
            this.addConfigurationChild(configuration, "outputFileFormat", "plain");
        } else {
            String outputXml = projectProperties.getProperty("maven.checkstyle.output.xml");
            if (outputXml != null) {
                this.addConfigurationChild(configuration, "outputFile", outputXml);
                this.addConfigurationChild(configuration, "outputFileFormat", "xml");
            }
        }
        this.addConfigurationChild(configuration, projectProperties, "maven.checkstyle.suppressions.file", "suppressionsLocation");
        this.addConfigurationChild(configuration, projectProperties, "maven.checkstyle.usefile", "useFile");
    }
}

