/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.converter.plugins;

import java.util.Properties;
import org.apache.maven.model.converter.ProjectConverterException;
import org.apache.maven.model.converter.plugins.AbstractPluginConfigurationConverter;
import org.apache.maven.model.converter.plugins.PropertyUtils;
import org.apache.maven.model.v3_0_0.Model;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PCCCompiler
extends AbstractPluginConfigurationConverter {
    public String getArtifactId() {
        return "maven-compiler-plugin";
    }

    public String getType() {
        return "build plugin";
    }

    protected void addOnOffConfigurationChild(Xpp3Dom configuration, Properties projectProperties, String mavenOneProperty, String mavenTwoElement) throws ProjectConverterException {
        String value = projectProperties.getProperty(mavenOneProperty);
        if (value != null) {
            this.addConfigurationChild(configuration, mavenTwoElement, PropertyUtils.convertOnOffToBoolean(value));
        }
    }

    protected void buildConfiguration(Xpp3Dom configuration, Model v3Model, Properties projectProperties) throws ProjectConverterException {
        String convertedNowarn;
        this.addOnOffConfigurationChild(configuration, projectProperties, "maven.compile.debug", "debug");
        this.addConfigurationChild(configuration, projectProperties, "maven.compile.encoding", "encoding");
        this.addConfigurationChild(configuration, projectProperties, "maven.compile.executable", "executable");
        String fork = projectProperties.getProperty("maven.compile.fork");
        if (fork != null) {
            this.addConfigurationChild(configuration, "fork", PropertyUtils.convertYesNoToBoolean(fork));
        }
        this.addConfigurationChild(configuration, projectProperties, "maven.compile.memoryMaximumSize", "maxmem");
        this.addConfigurationChild(configuration, projectProperties, "maven.compile.memoryInitialSize", "meminitial");
        this.addOnOffConfigurationChild(configuration, projectProperties, "maven.compile.optimize", "optimize");
        this.addOnOffConfigurationChild(configuration, projectProperties, "maven.compile.deprecation", "showDeprecation");
        String nowarn = projectProperties.getProperty("maven.compile.nowarn");
        if (nowarn != null && (convertedNowarn = PropertyUtils.convertOnOffToBoolean(nowarn)) != null) {
            String showWarnings = PropertyUtils.invertBoolean(convertedNowarn);
            this.addConfigurationChild(configuration, "showWarnings", showWarnings);
        }
        this.addConfigurationChild(configuration, projectProperties, "maven.compile.source", "source");
        this.addConfigurationChild(configuration, projectProperties, "maven.compile.target", "target");
        String value = projectProperties.getProperty("maven.compile.verbose");
        if (value != null) {
            this.addConfigurationChild(configuration, "verbose", PropertyUtils.convertYesNoToBoolean(value));
        }
    }
}

