/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.surefire.commonjunit48.org.codehaus.plexus.util.SelectorUtils;
import org.apache.maven.surefire.group.match.AndGroupMatcher;
import org.apache.maven.surefire.group.match.GroupMatcher;
import org.apache.maven.surefire.group.match.InverseGroupMatcher;
import org.apache.maven.surefire.group.parse.GroupMatcherParser;
import org.apache.maven.surefire.group.parse.ParseException;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class FilterFactory {
    private final ClassLoader testClassLoader;

    public FilterFactory(ClassLoader testClassLoader) {
        this.testClassLoader = testClassLoader;
    }

    public Filter createGroupFilter(Properties providerProperties) {
        String groups = providerProperties.getProperty("groups");
        String excludedGroups = providerProperties.getProperty("excludegroups");
        GroupMatcher included = null;
        if (groups != null) {
            try {
                included = new GroupMatcherParser(groups).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid group expression: '" + groups + "'. Reason: " + e.getMessage(), e);
            }
        }
        GroupMatcher excluded = null;
        if (excludedGroups != null) {
            try {
                excluded = new GroupMatcherParser(excludedGroups).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid group expression: '" + excludedGroups + "'. Reason: " + e.getMessage(), e);
            }
        }
        if (included != null && this.testClassLoader != null) {
            included.loadGroupClasses(this.testClassLoader);
        }
        if (excluded != null && this.testClassLoader != null) {
            excluded.loadGroupClasses(this.testClassLoader);
        }
        return new GroupMatcherCategoryFilter(included, excluded);
    }

    public Filter createMethodFilter(String requestedTestMethod) {
        return new MethodFilter(requestedTestMethod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombinedCategoryFilter
    extends Filter {
        private final List<Filter> includedFilters;
        private final List<Filter> excludedFilters;

        public CombinedCategoryFilter(List<Filter> includedFilters, List<Filter> excludedFilters) {
            this.includedFilters = includedFilters;
            this.excludedFilters = excludedFilters;
        }

        public boolean shouldRun(Description description) {
            return !(!this.includedFilters.isEmpty() && !this.inOneOfFilters(this.includedFilters, description) || !this.excludedFilters.isEmpty() && this.inOneOfFilters(this.excludedFilters, description));
        }

        private boolean inOneOfFilters(List<Filter> filters, Description description) {
            for (Filter f : filters) {
                if (!f.shouldRun(description)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            StringBuilder sb = new StringBuilder();
            if (!this.includedFilters.isEmpty()) {
                sb.append("(");
                sb.append(this.joinFilters(this.includedFilters, " OR "));
                sb.append(")");
                if (!this.excludedFilters.isEmpty()) {
                    sb.append(" AND ");
                }
            }
            if (!this.excludedFilters.isEmpty()) {
                sb.append("NOT (");
                sb.append(this.joinFilters(this.includedFilters, " OR "));
                sb.append(")");
            }
            return sb.toString();
        }

        private String joinFilters(List<Filter> filters, String sep) {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            for (Filter f : filters) {
                if (i++ > 0) {
                    sb.append(sep);
                }
                sb.append(f.describe());
            }
            return sb.toString();
        }
    }

    private static class GroupMatcherCategoryFilter
    extends Filter {
        private AndGroupMatcher matcher;
        private Map<Description, Boolean> shouldRunAnswers = new HashMap<Description, Boolean>();

        public GroupMatcherCategoryFilter(GroupMatcher included, GroupMatcher excluded) {
            InverseGroupMatcher invertedExclude;
            InverseGroupMatcher inverseGroupMatcher = invertedExclude = excluded == null ? null : new InverseGroupMatcher(excluded);
            if (included != null || invertedExclude != null) {
                this.matcher = new AndGroupMatcher(new GroupMatcher[0]);
                if (included != null) {
                    this.matcher.addMatcher(included);
                }
                if (invertedExclude != null) {
                    this.matcher.addMatcher((GroupMatcher)invertedExclude);
                }
            }
        }

        public boolean shouldRun(Description description) {
            return this.shouldRun(description, description.getMethodName() == null ? null : Description.createSuiteDescription((Class)description.getTestClass()));
        }

        private boolean shouldRun(Description description, Description parent) {
            Boolean result = this.shouldRunAnswers.get(description);
            if (result != null) {
                return result;
            }
            if (this.matcher == null) {
                return true;
            }
            HashSet<Class> cats = new HashSet<Class>();
            Category cat = (Category)description.getAnnotation(Category.class);
            if (cat != null) {
                cats.addAll(Arrays.asList(cat.value()));
            }
            if (parent != null && (cat = (Category)parent.getAnnotation(Category.class)) != null) {
                cats.addAll(Arrays.asList(cat.value()));
            }
            result = this.matcher.enabled(cats.toArray(new Class[0]));
            if (parent == null) {
                ArrayList children;
                if (cats.size() == 0) {
                    result = true;
                } else if (!result.booleanValue() && (children = description.getChildren()) != null) {
                    for (Description child : children) {
                        if (!this.shouldRun(child, description)) continue;
                        result = true;
                        break;
                    }
                }
            }
            this.shouldRunAnswers.put(description, result);
            return result == null ? false : result;
        }

        public String describe() {
            return this.matcher == null ? "ANY" : this.matcher.toString();
        }
    }

    private static class MethodFilter
    extends Filter {
        private final String requestedTestMethod;

        public MethodFilter(String requestedTestMethod) {
            this.requestedTestMethod = requestedTestMethod;
        }

        public boolean shouldRun(Description description) {
            for (Description o : description.getChildren()) {
                if (!this.isDescriptionMatch(o)) continue;
                return true;
            }
            return this.isDescriptionMatch(description);
        }

        private boolean isDescriptionMatch(Description description) {
            return description.getMethodName() != null && SelectorUtils.match(this.requestedTestMethod, description.getMethodName());
        }

        public String describe() {
            return "By method" + this.requestedTestMethod;
        }
    }
}

