/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import org.apache.maven.surefire.testset.ResolvedTest;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RequestedTest
extends Filter {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final ResolvedTest test;

    RequestedTest(ResolvedTest test) {
        this.test = test;
    }

    public boolean shouldRun(Description description) {
        Class realTestClass = description.getTestClass();
        String methodName = description.getMethodName();
        return realTestClass == null && methodName == null || this.test.shouldRun(this.classFile(realTestClass), methodName);
    }

    public String describe() {
        String description;
        String classPattern = this.test.getTestClassPattern();
        String methodPattern = this.test.getTestMethodPattern();
        String string = description = classPattern == null ? "" : classPattern;
        if (methodPattern != null) {
            description = description + "#" + methodPattern;
        }
        return description.length() == 0 ? "*" : description;
    }

    public boolean equals(Object o) {
        return this == o || o != null && ((Object)((Object)this)).getClass() == o.getClass() && this.test.equals((Object)((RequestedTest)((Object)o)).test);
    }

    public int hashCode() {
        return this.test.hashCode();
    }

    private String classFile(Class<?> realTestClass) {
        return realTestClass.getName().replace('.', '/') + CLASS_FILE_EXTENSION;
    }
}

