/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.apache.maven.plugin.surefire.booterclient.BooterSerializer;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.output.ForkClient;
import org.apache.maven.plugin.surefire.booterclient.output.ThreadedStreamConsumer;
import org.apache.maven.plugin.surefire.report.FileReporterFactory;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.StartupReportConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.suite.RunResult;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkStarter {
    private final int forkedProcessTimeoutInSeconds;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private final ForkConfiguration forkConfiguration;
    private final StartupReportConfiguration startupReportConfiguration;

    public ForkStarter(ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, ForkConfiguration forkConfiguration, int forkedProcessTimeoutInSeconds, StartupReportConfiguration startupReportConfiguration) {
        this.forkConfiguration = forkConfiguration;
        this.providerConfiguration = providerConfiguration;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult run() throws SurefireBooterForkException, SurefireExecutionException {
        RunResult result;
        block5: {
            String requestedForkMode = this.forkConfiguration.getForkMode();
            FileReporterFactory fileReporterFactory = new FileReporterFactory(this.startupReportConfiguration);
            try {
                if ("once".equals(requestedForkMode)) {
                    result = this.fork(null, this.providerConfiguration.getProviderProperties(), (ReporterFactory)fileReporterFactory);
                    break block5;
                }
                if ("always".equals(requestedForkMode)) {
                    result = this.runSuitesForkPerTestSet(fileReporterFactory);
                    break block5;
                }
                throw new SurefireExecutionException("Unknown forkmode: " + requestedForkMode, null);
            }
            finally {
                fileReporterFactory.close();
            }
        }
        return result;
    }

    private RunResult runSuitesForkPerTestSet(FileReporterFactory fileReporterFactory) throws SurefireBooterForkException {
        RunResult globalResult = new RunResult(0, 0, 0, 0);
        Iterator suites = this.getSuitesIterator();
        Properties properties = new Properties();
        while (suites.hasNext()) {
            Object testSet = suites.next();
            RunResult runResult = this.fork(testSet, properties, (ReporterFactory)fileReporterFactory);
            globalResult = globalResult.aggregate(runResult);
        }
        return globalResult;
    }

    private RunResult fork(Object testSet, Properties properties, ReporterFactory testSetReporterFactory) throws SurefireBooterForkException {
        RunResult runResult;
        File surefireProperties;
        File systemProperties = null;
        try {
            BooterSerializer booterSerializer = new BooterSerializer(this.forkConfiguration, properties);
            surefireProperties = booterSerializer.serialize(this.providerConfiguration, this.startupConfiguration, testSet, this.forkConfiguration.getForkMode());
            if (this.forkConfiguration.getSystemProperties() != null) {
                systemProperties = SystemPropertyManager.writePropertiesFile((Properties)this.forkConfiguration.getSystemProperties(), (File)this.forkConfiguration.getTempDirectory(), (String)"surefire", (boolean)this.forkConfiguration.isDebug());
            }
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating properties files for forking", (Throwable)e);
        }
        Classpath bootClasspathConfiguration = this.forkConfiguration.getBootClasspath();
        Classpath additionlClassPathUrls = this.startupConfiguration.useSystemClassLoader() ? this.startupConfiguration.getClasspathConfiguration().getTestClasspath() : null;
        Classpath bootClasspath = Classpath.join((Classpath)bootClasspathConfiguration, (Classpath)additionlClassPathUrls);
        Commandline cli = this.forkConfiguration.createCommandLine(bootClasspath.getClassPath(), this.startupConfiguration.getClassLoaderConfiguration(), this.startupConfiguration.isShadefire());
        cli.createArg().setFile(surefireProperties);
        if (systemProperties != null) {
            cli.createArg().setFile(systemProperties);
        }
        ForkClient out = new ForkClient(testSetReporterFactory, this.startupReportConfiguration.getTestVmSystemProperties());
        ThreadedStreamConsumer threadedStreamConsumer2 = new ThreadedStreamConsumer(out);
        if (this.forkConfiguration.isDebug()) {
            System.out.println("Forking command line: " + cli);
        }
        try {
            int timeout = this.forkedProcessTimeoutInSeconds > 0 ? this.forkedProcessTimeoutInSeconds : 0;
            CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)threadedStreamConsumer2, (StreamConsumer)threadedStreamConsumer2, (int)timeout);
            threadedStreamConsumer2.close();
            out.close();
            RunStatistics globalRunStatistics = testSetReporterFactory.getGlobalRunStatistics();
            runResult = globalRunStatistics.getRunResult();
        }
        catch (CommandLineTimeOutException e) {
            runResult = RunResult.Timeout;
        }
        catch (CommandLineException e) {
            throw new SurefireBooterForkException("Error while executing forked tests.", e.getCause());
        }
        return runResult;
    }

    private Iterator getSuitesIterator() throws SurefireBooterForkException {
        try {
            ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
            ClassLoader testsClassLoader = classpathConfiguration.createTestClassLoader(false);
            ClassLoader surefireClassLoader = classpathConfiguration.createSurefireClassLoader(testsClassLoader);
            SurefireReflector surefireReflector = new SurefireReflector(surefireClassLoader);
            Object reporterFactory = surefireReflector.createReportingReporterFactory(this.startupReportConfiguration);
            ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, surefireClassLoader, testsClassLoader, reporterFactory);
            SurefireProvider surefireProvider = providerFactory.createProvider();
            return surefireProvider.getSuites();
        }
        catch (SurefireExecutionException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", (Throwable)e);
        }
    }
}

