/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.CommonReflector;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.booterclient.BooterSerializer;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkNumberBucket;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.TestProvidingInputStream;
import org.apache.maven.plugin.surefire.booterclient.output.ForkClient;
import org.apache.maven.plugin.surefire.booterclient.output.ThreadedStreamConsumer;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineTimeOutException;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.ShutdownHookUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.util.DefaultScanResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkStarter {
    private final int forkedProcessTimeoutInSeconds;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private final ForkConfiguration forkConfiguration;
    private final StartupReportConfiguration startupReportConfiguration;
    private Log log;
    private final DefaultReporterFactory defaultReporterFactory;
    private static volatile int systemPropertiesFileCounter = 0;

    public ForkStarter(ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, ForkConfiguration forkConfiguration, int forkedProcessTimeoutInSeconds, StartupReportConfiguration startupReportConfiguration, Log log) {
        this.forkConfiguration = forkConfiguration;
        this.providerConfiguration = providerConfiguration;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
        this.log = log;
        this.defaultReporterFactory = new DefaultReporterFactory(startupReportConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult run(SurefireProperties effectiveSystemProperties, DefaultScanResult scanResult) throws SurefireBooterForkException, SurefireExecutionException {
        RunResult result;
        try {
            Properties providerProperties = this.providerConfiguration.getProviderProperties();
            scanResult.writeTo(providerProperties);
            if (this.isForkOnce()) {
                ForkClient forkClient = new ForkClient(this.defaultReporterFactory, this.startupReportConfiguration.getTestVmSystemProperties());
                result = this.fork(null, (KeyValueSource)new PropertiesWrapper(providerProperties), forkClient, effectiveSystemProperties, null);
            } else {
                result = this.forkConfiguration.isReuseForks() ? this.runSuitesForkOnceMultiple(effectiveSystemProperties, this.forkConfiguration.getForkCount()) : this.runSuitesForkPerTestSet(effectiveSystemProperties, this.forkConfiguration.getForkCount());
            }
        }
        finally {
            this.defaultReporterFactory.close();
        }
        return result;
    }

    private boolean isForkOnce() {
        return this.forkConfiguration.isReuseForks() && 1 == this.forkConfiguration.getForkCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkOnceMultiple(final SurefireProperties effectiveSystemProperties, int forkCount) throws SurefireBooterForkException {
        ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(forkCount);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(forkCount));
        try {
            RunResult globalResult = new RunResult(0, 0, 0, 0);
            ArrayList suites = new ArrayList();
            Iterator<Class<?>> suitesIterator = this.getSuitesIterator();
            while (suitesIterator.hasNext()) {
                suites.add(suitesIterator.next());
            }
            final ConcurrentLinkedQueue<String> messageQueue = new ConcurrentLinkedQueue<String>();
            for (Class clazz : suites) {
                messageQueue.add(clazz.getName());
            }
            for (int forkNum = 0; forkNum < forkCount && forkNum < suites.size(); ++forkNum) {
                Callable<RunResult> callable = new Callable<RunResult>(){

                    @Override
                    public RunResult call() throws Exception {
                        TestProvidingInputStream testProvidingInputStream = new TestProvidingInputStream(messageQueue);
                        ForkClient forkClient = new ForkClient(ForkStarter.this.defaultReporterFactory, ForkStarter.this.startupReportConfiguration.getTestVmSystemProperties(), testProvidingInputStream);
                        return ForkStarter.this.fork(null, (KeyValueSource)new PropertiesWrapper(ForkStarter.this.providerConfiguration.getProviderProperties()), forkClient, effectiveSystemProperties, testProvidingInputStream);
                    }
                };
                results.add(executorService.submit(callable));
            }
            for (Future future : results) {
                try {
                    RunResult cur = (RunResult)future.get();
                    if (cur != null) {
                        globalResult = globalResult.aggregate(cur);
                        continue;
                    }
                    throw new SurefireBooterForkException("No results for " + future.toString());
                }
                catch (InterruptedException e) {
                    throw new SurefireBooterForkException("Interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new SurefireBooterForkException("ExecutionException", (Throwable)e);
                }
            }
            RunResult runResult = globalResult;
            return runResult;
        }
        finally {
            this.closeExecutor(executorService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkPerTestSet(final SurefireProperties effectiveSystemProperties, int forkCount) throws SurefireBooterForkException {
        ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(500);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            RunResult globalResult = new RunResult(0, 0, 0, 0);
            Iterator<Class<?>> suites = this.getSuitesIterator();
            while (suites.hasNext()) {
                final Class<?> testSet = suites.next();
                Callable<RunResult> callable = new Callable<RunResult>(){

                    @Override
                    public RunResult call() throws Exception {
                        ForkClient forkClient = new ForkClient(ForkStarter.this.defaultReporterFactory, ForkStarter.this.startupReportConfiguration.getTestVmSystemProperties());
                        return ForkStarter.this.fork(testSet, (KeyValueSource)new PropertiesWrapper(ForkStarter.this.providerConfiguration.getProviderProperties()), forkClient, effectiveSystemProperties, null);
                    }
                };
                results.add(executorService.submit(callable));
            }
            for (Future future : results) {
                try {
                    RunResult cur = (RunResult)future.get();
                    if (cur != null) {
                        globalResult = globalResult.aggregate(cur);
                        continue;
                    }
                    throw new SurefireBooterForkException("No results for " + future.toString());
                }
                catch (InterruptedException e) {
                    throw new SurefireBooterForkException("Interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new SurefireBooterForkException("ExecutionException", (Throwable)e);
                }
            }
            RunResult runResult = globalResult;
            return runResult;
        }
        finally {
            this.closeExecutor(executorService);
        }
    }

    private void closeExecutor(ExecutorService executorService) throws SurefireBooterForkException {
        executorService.shutdown();
        try {
            executorService.awaitTermination(3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new SurefireBooterForkException("Interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult fork(Object testSet, KeyValueSource providerProperties, ForkClient forkClient, SurefireProperties effectiveSystemProperties, TestProvidingInputStream testProvidingInputStream) throws SurefireBooterForkException {
        int forkNumber = ForkNumberBucket.drawNumber();
        try {
            RunResult runResult = this.fork(testSet, providerProperties, forkClient, effectiveSystemProperties, forkNumber, testProvidingInputStream);
            return runResult;
        }
        finally {
            ForkNumberBucket.returnNumber(forkNumber);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RunResult fork(Object testSet, KeyValueSource providerProperties, ForkClient forkClient, SurefireProperties effectiveSystemProperties, int forkNumber, TestProvidingInputStream testProvidingInputStream) throws SurefireBooterForkException {
        RunResult runResult;
        OutputStreamFlushableCommandline cli;
        block29: {
            Thread inputStreamCloserHook;
            InputStreamCloser inputStreamCloser;
            File surefireProperties;
            File systPropsFile = null;
            try {
                BooterSerializer booterSerializer = new BooterSerializer(this.forkConfiguration);
                surefireProperties = booterSerializer.serialize(providerProperties, this.providerConfiguration, this.startupConfiguration, testSet, null != testProvidingInputStream);
                if (effectiveSystemProperties != null) {
                    SurefireProperties filteredProperties = AbstractSurefireMojo.createCopyAndReplaceForkNumPlaceholder(effectiveSystemProperties, forkNumber);
                    systPropsFile = SystemPropertyManager.writePropertiesFile((Properties)filteredProperties, (File)this.forkConfiguration.getTempDirectory(), (String)("surefire_" + systemPropertiesFileCounter++), (boolean)this.forkConfiguration.isDebug());
                }
            }
            catch (IOException e) {
                throw new SurefireBooterForkException("Error creating properties files for forking", (Throwable)e);
            }
            Classpath bootClasspathConfiguration = this.startupConfiguration.isProviderMainClass() ? this.startupConfiguration.getClasspathConfiguration().getProviderClasspath() : this.forkConfiguration.getBootClasspath();
            Classpath additionlClassPathUrls = this.startupConfiguration.useSystemClassLoader() ? this.startupConfiguration.getClasspathConfiguration().getTestClasspath() : null;
            Classpath bootClasspath = Classpath.join((Classpath)bootClasspathConfiguration, (Classpath)additionlClassPathUrls);
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)bootClasspath.getLogMessage("boot"));
            }
            cli = this.forkConfiguration.createCommandLine(bootClasspath.getClassPath(), this.startupConfiguration, forkNumber);
            if (testProvidingInputStream != null) {
                testProvidingInputStream.setFlushReceiverProvider(cli);
                inputStreamCloser = new InputStreamCloser(testProvidingInputStream);
                inputStreamCloserHook = new Thread(inputStreamCloser);
                ShutdownHookUtils.addShutDownHook(inputStreamCloserHook);
            } else {
                inputStreamCloser = null;
                inputStreamCloserHook = null;
            }
            cli.createArg().setFile(surefireProperties);
            if (systPropsFile != null) {
                cli.createArg().setFile(systPropsFile);
            }
            ThreadedStreamConsumer threadedStreamConsumer = new ThreadedStreamConsumer(forkClient);
            if (this.forkConfiguration.isDebug()) {
                System.out.println("Forking command line: " + cli);
            }
            runResult = null;
            try {
                try {
                    int timeout = this.forkedProcessTimeoutInSeconds > 0 ? this.forkedProcessTimeoutInSeconds : 0;
                    int result = CommandLineUtils.executeCommandLine(cli, testProvidingInputStream, threadedStreamConsumer, threadedStreamConsumer, timeout, inputStreamCloser);
                    if (result != 0) {
                        throw new SurefireBooterForkException("Error occurred in starting fork, check output in log");
                    }
                    Object var20_22 = null;
                    threadedStreamConsumer.close();
                    if (inputStreamCloser == null) break block29;
                    inputStreamCloser.run();
                }
                catch (CommandLineTimeOutException e) {
                    runResult = RunResult.timeout((RunResult)this.defaultReporterFactory.getGlobalRunStatistics().getRunResult());
                    Object var20_23 = null;
                    threadedStreamConsumer.close();
                    if (inputStreamCloser != null) {
                        inputStreamCloser.run();
                        ShutdownHookUtils.removeShutdownHook(inputStreamCloserHook);
                    }
                    if (runResult == null) {
                        runResult = this.defaultReporterFactory.getGlobalRunStatistics().getRunResult();
                    }
                    if (!runResult.isTimeout()) {
                        StackTraceWriter errorInFork = forkClient.getErrorInFork();
                        if (errorInFork != null) {
                            throw new RuntimeException("There was an error in the forked process\n" + errorInFork.writeTraceToString());
                        }
                        if (!forkClient.isSaidGoodBye()) {
                            throw new RuntimeException("The forked VM terminated without saying properly goodbye. VM crash or System.exit called ?\nCommand was" + cli.toString());
                        }
                    }
                    forkClient.close(runResult.isTimeout());
                    return runResult;
                }
                catch (CommandLineException e) {
                    runResult = RunResult.failure((RunResult)this.defaultReporterFactory.getGlobalRunStatistics().getRunResult(), (Exception)e);
                    throw new SurefireBooterForkException("Error while executing forked tests.", e.getCause());
                }
            }
            catch (Throwable throwable) {
                Object var20_24 = null;
                threadedStreamConsumer.close();
                if (inputStreamCloser != null) {
                    inputStreamCloser.run();
                    ShutdownHookUtils.removeShutdownHook(inputStreamCloserHook);
                }
                if (runResult == null) {
                    runResult = this.defaultReporterFactory.getGlobalRunStatistics().getRunResult();
                }
                if (!runResult.isTimeout()) {
                    StackTraceWriter errorInFork = forkClient.getErrorInFork();
                    if (errorInFork != null) {
                        throw new RuntimeException("There was an error in the forked process\n" + errorInFork.writeTraceToString());
                    }
                    if (!forkClient.isSaidGoodBye()) {
                        throw new RuntimeException("The forked VM terminated without saying properly goodbye. VM crash or System.exit called ?\nCommand was" + cli.toString());
                    }
                }
                forkClient.close(runResult.isTimeout());
                throw throwable;
            }
            ShutdownHookUtils.removeShutdownHook(inputStreamCloserHook);
        }
        if (runResult == null) {
            runResult = this.defaultReporterFactory.getGlobalRunStatistics().getRunResult();
        }
        if (!runResult.isTimeout()) {
            StackTraceWriter errorInFork = forkClient.getErrorInFork();
            if (errorInFork != null) {
                throw new RuntimeException("There was an error in the forked process\n" + errorInFork.writeTraceToString());
            }
            if (!forkClient.isSaidGoodBye()) {
                throw new RuntimeException("The forked VM terminated without saying properly goodbye. VM crash or System.exit called ?\nCommand was" + cli.toString());
            }
        }
        forkClient.close(runResult.isTimeout());
        return runResult;
    }

    private Iterator<Class<?>> getSuitesIterator() throws SurefireBooterForkException {
        try {
            ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
            ClassLoader testsClassLoader = classpathConfiguration.createTestClassLoader(false);
            ClassLoader surefireClassLoader = classpathConfiguration.createInprocSurefireClassLoader(testsClassLoader);
            CommonReflector commonReflector = new CommonReflector(surefireClassLoader);
            Object reporterFactory = commonReflector.createReportingReporterFactory(this.startupReportConfiguration);
            ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, surefireClassLoader, testsClassLoader, reporterFactory);
            SurefireProvider surefireProvider = providerFactory.createProvider(false);
            return surefireProvider.getSuites();
        }
        catch (SurefireExecutionException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", (Throwable)e);
        }
    }

    private final class InputStreamCloser
    implements Runnable {
        private InputStream testProvidingInputStream;

        public InputStreamCloser(InputStream testProvidingInputStream) {
            this.testProvidingInputStream = testProvidingInputStream;
        }

        public synchronized void run() {
            if (this.testProvidingInputStream != null) {
                try {
                    this.testProvidingInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.testProvidingInputStream = null;
            }
        }
    }
}

