/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;
import org.codehaus.plexus.util.StringUtils;

public class BooterSerializer {
    private final ForkConfiguration forkConfiguration;
    private final PropertiesWrapper properties;

    public BooterSerializer(ForkConfiguration forkConfiguration, Properties properties) {
        this.forkConfiguration = forkConfiguration;
        this.properties = new PropertiesWrapper(properties);
    }

    public File serialize(ProviderConfiguration booterConfiguration, StartupConfiguration providerConfiguration, Object testSet) throws IOException {
        DirectoryScannerParameters directoryScannerParameters;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{"directoryScannerOptions", booterConfiguration.getDirScannerParamsArray()});
        this.addPropertiesForTypeHolder(params, this.properties.getProperties(), "dirscanner.");
        providerConfiguration.getClasspathConfiguration().setForkProperties(this.properties.getProperties());
        TestArtifactInfo testNg = booterConfiguration.getTestArtifact();
        if (testNg != null) {
            this.properties.setProperty("testFwJarVersion", testNg.getVersion());
            this.properties.setProperty("testFwJarClassifier", testNg.getClassifier());
        }
        this.properties.setProperty("forkTestSet", this.getTypeEncoded(testSet));
        TestRequest testSuiteDefinition = booterConfiguration.getTestSuiteDefinition();
        if (testSuiteDefinition != null) {
            this.properties.setProperty("testSuiteDefinitionTestSourceDirectory", testSuiteDefinition.getTestSourceDirectory());
            this.properties.addList(testSuiteDefinition.getSuiteXmlFiles(), "testSuiteXmlFiles");
            this.properties.setProperty("requestedTest", testSuiteDefinition.getRequestedTest());
        }
        if ((directoryScannerParameters = booterConfiguration.getDirScannerParams()) != null) {
            this.properties.setProperty("failIfNoTests", String.valueOf(directoryScannerParameters.isFailIfNoTests()));
            this.properties.addList(directoryScannerParameters.getIncludes(), "includes");
            this.properties.addList(directoryScannerParameters.getExcludes(), "excludes");
            this.properties.setProperty("testClassesDirectory", directoryScannerParameters.getTestClassesDirectory());
            this.properties.setProperty("runOrder", directoryScannerParameters.getRunOrder());
        }
        ReporterConfiguration reporterConfiguration = booterConfiguration.getReporterConfiguration();
        this.addList(reporterConfiguration.getReports(), this.properties.getProperties(), "report.");
        Boolean rep = reporterConfiguration.isTrimStackTrace();
        this.properties.setProperty("isTrimStackTrace", rep);
        this.properties.setProperty("reportsDirectory", reporterConfiguration.getReportsDirectory());
        ClassLoaderConfiguration classLoaderConfiguration = providerConfiguration.getClassLoaderConfiguration();
        this.properties.setProperty("useSystemClassLoader", String.valueOf(classLoaderConfiguration.isUseSystemClassLoader()));
        this.properties.setProperty("useManifestOnlyJar", String.valueOf(classLoaderConfiguration.isUseManifestOnlyJar()));
        this.properties.setProperty("failIfNoTests", String.valueOf(booterConfiguration.isFailIfNoTests()));
        this.properties.setProperty("providerConfiguration", providerConfiguration.getProviderClassName());
        return SystemPropertyManager.writePropertiesFile((Properties)this.properties.getProperties(), (File)this.forkConfiguration.getTempDirectory(), (String)"surefire", (boolean)this.forkConfiguration.isDebug());
    }

    private String getTypeEncoded(Object value) {
        if (value == null) {
            return null;
        }
        String valueToUse = value instanceof Class ? ((Class)value).getName() : value.toString();
        return value.getClass().getName() + "|" + valueToUse;
    }

    private void addPropertiesForTypeHolder(List typeHolderList, Properties properties, String propertyPrefix) {
        for (int i = 0; i < typeHolderList.size(); ++i) {
            Object[] report = (Object[])typeHolderList.get(i);
            String className = (String)report[0];
            Object[] params = (Object[])report[1];
            properties.setProperty(propertyPrefix + i, className);
            if (params == null) continue;
            String paramProperty = this.getValues(params);
            String typeProperty = this.getTypes(params);
            properties.setProperty(propertyPrefix + i + ".params", paramProperty);
            properties.setProperty(propertyPrefix + i + ".types", typeProperty);
        }
    }

    private String getValues(Object[] params) {
        StringBuffer result = new StringBuffer();
        if (params != null && params.length > 0) {
            result.append(BooterSerializer.convert(params[0]));
            for (int j = 1; j < params.length; ++j) {
                result.append("|");
                if (params[j] == null) continue;
                result.append(BooterSerializer.convert(params[j]));
            }
        }
        return result.toString();
    }

    private String getTypes(Object[] params) {
        StringBuffer result = new StringBuffer();
        if (params != null && params.length > 0) {
            result.append(params[0].getClass().getName());
            for (int j = 1; j < params.length; ++j) {
                result.append("|");
                if (params[j] == null) continue;
                result.append(params[j].getClass().getName());
            }
        }
        return result.toString();
    }

    private static String convert(Object param) {
        if (param instanceof File[]) {
            Object[] files = (File[])param;
            return "[" + StringUtils.join((Object[])files, (String)",") + "]";
        }
        if (param instanceof Properties) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ((Properties)param).store(baos, "");
                return new String(baos.toByteArray(), "8859_1");
            }
            catch (Exception e) {
                throw new RuntimeException("bug in property conversion", e);
            }
        }
        return param.toString();
    }

    private void addList(List items, Properties properties, String propertyPrefix) {
        for (int i = 0; i < items.size(); ++i) {
            Object item = items.get(i);
            if (item == null) {
                throw new NullPointerException(propertyPrefix + i + " has null value");
            }
            properties.setProperty(propertyPrefix + i, item.toString());
        }
    }
}

