/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.booterclient.output.MultipleFailureException;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.extensions.EventHandler;

public final class ThreadedStreamConsumer
implements EventHandler<Event>,
Closeable {
    private static final int QUEUE_MAX_ITEMS = 10000;
    private static final Event END_ITEM = new FinalEvent();
    private final QueueSynchronizer<Event> synchronizer = new QueueSynchronizer<Event>(10000, END_ITEM);
    private final AtomicBoolean stop = new AtomicBoolean();
    private final AtomicBoolean isAlive = new AtomicBoolean(true);
    private final Thread consumer;
    private final Pumper pumper;

    public ThreadedStreamConsumer(EventHandler<Event> target) {
        this.pumper = new Pumper(target);
        Thread consumer = DaemonThreadFactory.newDaemonThread((Runnable)this.pumper, (String)"ThreadedStreamConsumer");
        consumer.setUncaughtExceptionHandler((t, e) -> this.isAlive.set(false));
        consumer.start();
        this.consumer = consumer;
    }

    public void handleEvent(@Nonnull Event event) {
        if (!this.stop.get() && this.isAlive.get()) {
            this.synchronizer.pushNext(event);
        }
    }

    @Override
    public void close() throws IOException {
        this.isAlive.compareAndSet(true, this.consumer.isAlive());
        if (this.stop.compareAndSet(false, true) && this.isAlive.get()) {
            if (Thread.currentThread().isInterrupted()) {
                this.synchronizer.markStopped();
                this.consumer.interrupt();
            } else {
                this.synchronizer.markStopped();
                try {
                    this.consumer.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.synchronizer.clearQueue();
            }
        }
        if (this.pumper.hasErrors()) {
            this.pumper.throwErrors();
        }
    }

    private static boolean shouldStopQueueing(Event item) {
        return item == END_ITEM;
    }

    static class QueueSynchronizer<T> {
        private final SyncT1 t1 = new SyncT1();
        private final SyncT2 t2 = new SyncT2();
        private final ConcurrentLinkedDeque<T> queue = new ConcurrentLinkedDeque();
        private final AtomicInteger queueSize = new AtomicInteger();
        private final int maxQueueSize;
        private final T stopItemMarker;

        QueueSynchronizer(int maxQueueSize, T stopItemMarker) {
            this.maxQueueSize = maxQueueSize;
            this.stopItemMarker = stopItemMarker;
        }

        void markStopped() {
            this.addNext(this.stopItemMarker);
        }

        void pushNext(T t) {
            this.t2.awaitMax();
            this.addNext(t);
        }

        T awaitNext() throws InterruptedException {
            this.t2.tryRelease();
            this.t1.waitIfZero();
            this.queueSize.decrementAndGet();
            return this.queue.pollFirst();
        }

        boolean isEmptyQueue() {
            return this.queue.isEmpty();
        }

        void clearQueue() {
            this.queue.clear();
        }

        private void addNext(T t) {
            this.queue.addLast(t);
            if (this.queueSize.getAndIncrement() == 0) {
                this.t1.release();
            }
        }

        private class SyncT2
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 1L;

            private SyncT2() {
            }

            @Override
            protected int tryAcquireShared(int arg) {
                return QueueSynchronizer.this.queueSize.get() < QueueSynchronizer.this.maxQueueSize ? 1 : -1;
            }

            @Override
            protected boolean tryReleaseShared(int arg) {
                return true;
            }

            void awaitMax() {
                this.acquireShared(1);
            }

            void tryRelease() {
                if (QueueSynchronizer.this.queueSize.get() == 0) {
                    this.releaseShared(0);
                }
            }
        }

        private class SyncT1
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 1L;

            private SyncT1() {
            }

            @Override
            protected int tryAcquireShared(int arg) {
                return QueueSynchronizer.this.queueSize.get() == 0 ? -1 : 1;
            }

            @Override
            protected boolean tryReleaseShared(int arg) {
                return true;
            }

            void waitIfZero() throws InterruptedException {
                this.acquireSharedInterruptibly(1);
            }

            void release() {
                this.releaseShared(0);
            }
        }
    }

    private static class FinalEvent
    extends Event {
        FinalEvent() {
            super(null);
        }

        public boolean isControlCategory() {
            return false;
        }

        public boolean isConsoleCategory() {
            return false;
        }

        public boolean isConsoleErrorCategory() {
            return false;
        }

        public boolean isStandardStreamCategory() {
            return false;
        }

        public boolean isSysPropCategory() {
            return false;
        }

        public boolean isTestCategory() {
            return false;
        }

        public boolean isJvmExitError() {
            return false;
        }
    }

    final class Pumper
    implements Runnable {
        private final EventHandler<Event> target;
        private final MultipleFailureException errors = new MultipleFailureException();

        Pumper(EventHandler<Event> target) {
            this.target = target;
        }

        @Override
        public void run() {
            while (!ThreadedStreamConsumer.this.stop.get() || !ThreadedStreamConsumer.this.synchronizer.isEmptyQueue()) {
                try {
                    Event item = (Event)ThreadedStreamConsumer.this.synchronizer.awaitNext();
                    if (ThreadedStreamConsumer.shouldStopQueueing(item)) break;
                    this.target.handleEvent((Object)item);
                }
                catch (Throwable t) {
                    t.getStackTrace();
                    this.errors.addException(t);
                }
            }
            ThreadedStreamConsumer.this.isAlive.set(false);
        }

        boolean hasErrors() {
            return this.errors.hasNestedExceptions();
        }

        void throwErrors() throws IOException {
            throw this.errors;
        }
    }
}

