/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.text.NumberFormat;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;

public abstract class AbstractReporter
implements Reporter {
    private String reportsDirectory;
    protected int completedCount;
    protected int errors;
    protected int failures;
    protected long startTime;
    protected long endTime;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public void setReportsDirectory(String reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void writeMessage(String message) {
    }

    public void runStarting(int testCount) {
    }

    public void runCompleted() {
    }

    public void runStopped() {
    }

    public void runAborted(ReportEntry report) {
    }

    public void batteryStarting(ReportEntry report) throws Exception {
    }

    public void batteryCompleted(ReportEntry report) {
    }

    public void batteryAborted(ReportEntry report) {
    }

    public void testStarting(ReportEntry report) {
        this.startTime = System.currentTimeMillis();
    }

    public void testSucceeded(ReportEntry report) {
        ++this.completedCount;
        this.endTime = System.currentTimeMillis();
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        ++this.completedCount;
        ++this.errors;
        this.endTime = System.currentTimeMillis();
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        ++this.completedCount;
        ++this.failures;
        this.endTime = System.currentTimeMillis();
    }

    public int getNbErrors() {
        return this.errors;
    }

    public int getNbFailures() {
        return this.failures;
    }

    public int getNbTests() {
        return this.completedCount;
    }

    public void dispose() {
    }

    protected String elapsedTimeAsString(long runTime) {
        return this.numberFormat.format((double)runTime / 1000.0);
    }
}

