/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;

public class ConsoleReporter
extends AbstractReporter {
    protected static final int BUFFER_SIZE = 4096;
    protected PrintWriter writer = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(System.out, 4096)));
    protected long batteryStartTime;

    public void println(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    public void print(String message) {
        this.writer.print(message);
        this.writer.flush();
    }

    public void runStarting(int testCount) {
        this.println("");
        this.println("-------------------------------------------------------");
        this.println(" T E S T S");
        this.println("-------------------------------------------------------");
    }

    public void runAborted(ReportEntry report) {
        this.println("RUN ABORTED");
        this.println(report.getSource().getClass().getName());
        this.println(report.getName());
        this.println(report.getMessage());
        this.println(report.getThrowable().getMessage());
    }

    public void batteryAborted(ReportEntry report) {
        this.println("BATTERY ABORTED");
        this.println(report.getSource().getClass().getName());
        this.println(report.getName());
        this.println(report.getMessage());
        this.println(report.getThrowable().getMessage());
    }

    public void batteryStarting(ReportEntry report) throws Exception {
        this.batteryStartTime = System.currentTimeMillis();
        this.println("[surefire] Running " + report.getName());
    }

    public void batteryCompleted(ReportEntry report) {
        long runTime = System.currentTimeMillis() - this.batteryStartTime;
        this.print("[surefire] Tests run: " + this.completedCount + ", Failures: " + this.failures + ", Errors: " + this.errors + ", Time elapsed: " + this.elapsedTimeAsString(runTime) + " sec");
        if (this.failures > 0 || this.errors > 0) {
            this.writer.print(" <<<<<<<< FAILURE !! ");
        }
        this.writer.println("");
        this.writer.flush();
        this.completedCount = 0;
        this.errors = 0;
        this.failures = 0;
    }
}

