/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public class XMLReporter
extends AbstractReporter {
    private PrintWriter writer;
    private Xpp3Dom testSuite;
    private Xpp3Dom testCase;
    private long batteryStartTime;

    public void setTestCase(Xpp3Dom testCase) {
        this.testCase = testCase;
    }

    public Xpp3Dom getTestCase() {
        return this.testCase;
    }

    public void runStarting(int testCount) {
    }

    public void batteryStarting(ReportEntry report) throws Exception {
        this.batteryStartTime = System.currentTimeMillis();
        File reportFile = new File(this.getReportsDirectory(), "TEST-" + report.getName() + ".xml");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8")));
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        this.testSuite = new Xpp3Dom("testsuite");
        this.testSuite.setAttribute("name", report.getName());
        this.showProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batteryCompleted(ReportEntry report) {
        this.testSuite.setAttribute("tests", String.valueOf(this.getNbTests()));
        this.testSuite.setAttribute("errors", String.valueOf(this.getNbErrors()));
        this.testSuite.setAttribute("failures", String.valueOf(this.getNbFailures()));
        long runTime = System.currentTimeMillis() - this.batteryStartTime;
        this.testSuite.setAttribute("time", this.elapsedTimeAsString(runTime));
        try {
            Xpp3DomWriter.write((Writer)this.writer, (Xpp3Dom)this.testSuite);
        }
        finally {
            IOUtil.close((Writer)this.writer);
        }
    }

    public void testStarting(ReportEntry report) {
        super.testStarting(report);
        String reportName = report.getName().indexOf("(") > 0 ? report.getName().substring(0, report.getName().indexOf("(")) : report.getName();
        this.testCase = this.createElement(this.testSuite, "testcase");
        this.testCase.setAttribute("name", reportName);
    }

    public void testSucceeded(ReportEntry report) {
        super.testSucceeded(report);
        long runTime = this.endTime - this.startTime;
        this.testCase.setAttribute("time", this.elapsedTimeAsString(runTime));
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        super.testError(report, stdOut, stdErr);
        Xpp3Dom element = this.createElement(this.testCase, "error");
        this.writeTestProblems(report, stdOut, stdErr, element);
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        super.testFailed(report, stdOut, stdErr);
        Xpp3Dom element = this.createElement(this.testCase, "failure");
        this.writeTestProblems(report, stdOut, stdErr, element);
    }

    private void writeTestProblems(ReportEntry report, String stdOut, String stdErr, Xpp3Dom element) {
        String stackTrace = this.getStackTrace(report);
        Throwable t = report.getThrowable();
        if (t != null) {
            String message = t.getMessage();
            if (message != null && message.trim().length() > 0) {
                element.setAttribute("message", XMLReporter.escapeAttribute(message));
                element.setAttribute("type", stackTrace.substring(0, stackTrace.indexOf(":")));
            } else {
                element.setAttribute("type", new StringTokenizer(stackTrace).nextToken());
            }
        }
        element.setValue(stackTrace);
        if (stdOut != null && stdOut.trim().length() > 0) {
            this.createElement(this.testCase, "system-out").setValue(stdOut);
        }
        if (stdErr != null && stdErr.trim().length() > 0) {
            this.createElement(this.testCase, "system-err").setValue(stdErr);
        }
        long runTime = this.endTime - this.startTime;
        this.testCase.setAttribute("time", this.elapsedTimeAsString(runTime));
    }

    public void dispose() {
        this.errors = 0;
        this.failures = 0;
        this.completedCount = 0;
    }

    private Xpp3Dom createElement(Xpp3Dom element, String name) {
        Xpp3Dom component = new Xpp3Dom(name);
        element.addChild(component);
        return component;
    }

    private String getStackTrace(ReportEntry report) {
        StringWriter writer = new StringWriter();
        report.getThrowable().printStackTrace(new PrintWriter(writer));
        writer.flush();
        return writer.toString();
    }

    private void showProperties() {
        Xpp3Dom properties = this.createElement(this.testSuite, "properties");
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                String value = systemProperties.getProperty(key);
                if (value == null) {
                    value = "null";
                }
                Xpp3Dom property = this.createElement(properties, "property");
                property.setAttribute("name", key);
                property.setAttribute("value", XMLReporter.escapeAttribute(value));
            }
        }
    }

    private static String escapeAttribute(String attribute) {
        return attribute.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

