/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;

public class BriefFileReporter
extends AbstractReporter {
    private PrintWriter writer;
    private StringBuffer reportContent;
    private long batteryStartTime;

    public void runStarting(int testCount) {
    }

    public void batteryStarting(ReportEntry report) throws Exception {
        this.batteryStartTime = System.currentTimeMillis();
        this.reportContent = new StringBuffer();
        File reportFile = new File(this.getReportsDirectory(), report.getName() + ".txt");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        this.writer = new PrintWriter(new FileWriter(reportFile));
        this.writer.println("-------------------------------------------------------------------------------");
        this.writer.println("Battery: " + report.getName());
        this.writer.println("-------------------------------------------------------------------------------");
    }

    public void batteryCompleted(ReportEntry report) {
        long runTime = System.currentTimeMillis() - this.batteryStartTime;
        StringBuffer batterySummary = new StringBuffer();
        batterySummary.append("Tests run: " + String.valueOf(this.getNbTests())).append(", Failures: " + String.valueOf(this.getNbFailures())).append(", Errors: " + String.valueOf(this.getNbErrors())).append(", Time elapsed: " + this.elapsedTimeAsString(runTime)).append(" sec \n\n");
        this.reportContent = batterySummary.append(this.reportContent);
        this.writer.println(this.reportContent.toString());
        this.writer.flush();
        this.writer.close();
    }

    public void testStarting(ReportEntry report) {
        super.testStarting(report);
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        super.testError(report, stdOut, stdErr);
        this.reportContent.append(report.getName());
        long runTime = this.endTime - this.startTime;
        this.writeTimeElapsed(runTime);
        this.reportContent.append("  <<< ERROR!\n");
        this.writeStdLogs(stdOut, stdErr);
        this.reportContent.append(this.getStackTrace(report) + "\n");
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        super.testFailed(report, stdOut, stdErr);
        this.reportContent.append(report.getName());
        long runTime = this.endTime - this.startTime;
        this.writeTimeElapsed(runTime);
        this.reportContent.append("  <<< FAILURE!\n");
        this.writeStdLogs(stdOut, stdErr);
        this.reportContent.append(this.getStackTrace(report) + "\n");
    }

    public void dispose() {
        this.errors = 0;
        this.failures = 0;
        this.completedCount = 0;
    }

    private void writeTimeElapsed(long sec) {
        this.reportContent.append("  Time elapsed: " + this.elapsedTimeAsString(sec) + " sec");
    }

    private void writeStdLogs(String stdOut, String stdErr) {
        this.reportContent.append("\n");
        this.reportContent.append("[ stdout ] ---------------------------------------------------------------\n");
        this.reportContent.append("\n");
        this.reportContent.append(stdOut + "\n");
        this.reportContent.append("\n");
        this.reportContent.append("[ stderr ] ---------------------------------------------------------------\n");
        this.reportContent.append("\n");
        this.reportContent.append(stdErr + "\n");
        this.reportContent.append("\n");
        this.reportContent.append("[ stacktrace ] -----------------------------------------------------------\n");
        this.reportContent.append("\n");
    }

    private String getStackTrace(ReportEntry report) {
        StringWriter writer = new StringWriter();
        report.getThrowable().printStackTrace(new PrintWriter(writer));
        writer.flush();
        return writer.toString();
    }
}

