/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.Surefire;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.util.TeeStream;

public class ReporterManager {
    private int completedCount;
    private int errors;
    private int failures;
    private List reports;
    private String reportsDirectory;
    private PrintStream oldOut;
    private PrintStream oldErr;
    private PrintStream newErr;
    private PrintStream newOut;
    private ByteArrayOutputStream stdOut;
    private ByteArrayOutputStream stdErr;

    public ReporterManager(List reports, String reportsDirectory) {
        if (reports == null) {
            throw new NullPointerException();
        }
        this.reportsDirectory = reportsDirectory;
        this.reports = reports;
    }

    public void addReporter(Reporter reporter) {
        if (reporter == null) {
            throw new NullPointerException();
        }
        if (!this.reports.contains(reporter)) {
            this.reports.add(reporter);
        }
    }

    public void removeReport(Reporter report) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (this.reports.contains(report)) {
            this.reports.remove(report);
        }
    }

    public List getReports() {
        return this.reports;
    }

    public void writeMessage(String message) {
        Iterator i = this.reports.iterator();
        while (i.hasNext()) {
            Reporter report = (Reporter)i.next();
            report.writeMessage(message);
        }
    }

    public void resume() {
        this.writeMessage("");
        this.writeMessage("Results :");
        this.writeMessage("[surefire] Tests run: " + this.completedCount + ", Failures: " + this.failures + ", Errors: " + this.errors);
        this.writeMessage("");
    }

    public void runStarting(int testCount) {
        if (testCount < 0) {
            throw new IllegalArgumentException("testCount is less than zero");
        }
        Iterator i = this.reports.iterator();
        while (i.hasNext()) {
            Reporter report = (Reporter)i.next();
            try {
                report.runStarting(testCount);
            }
            catch (Exception e) {
                this.handleReporterException("runStarting", e);
            }
        }
    }

    public void runStopped() {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.runStopped();
            }
            catch (Exception e) {
                this.handleReporterException("runStopped", e);
            }
        }
    }

    public void runAborted(ReportEntry report) {
        if (report == null) {
            throw new NullPointerException();
        }
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.runAborted(report);
            }
            catch (Exception e) {
                this.handleReporterException("runAborted", e);
            }
        }
        ++this.errors;
    }

    public void runCompleted() {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.runCompleted();
            }
            catch (Exception e) {
                this.handleReporterException("runCompleted", e);
            }
        }
    }

    public void batteryStarting(ReportEntry report) {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.batteryStarting(report);
            }
            catch (Exception e) {
                this.handleReporterException("suiteStarting", e);
            }
        }
    }

    public void batteryCompleted(ReportEntry report) {
        if (!this.reports.isEmpty()) {
            Reporter reporter = (Reporter)this.reports.get(0);
            this.errors += reporter.getNbErrors();
            this.failures += reporter.getNbFailures();
            this.completedCount += reporter.getNbTests();
        }
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.batteryCompleted(report);
            }
            catch (Exception e) {}
        }
    }

    public void batteryAborted(ReportEntry report) {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.batteryAborted(report);
            }
            catch (Exception e) {
                this.handleReporterException("suiteAborted", e);
            }
        }
        ++this.errors;
    }

    public void testStarting(ReportEntry report) {
        File f = new File(this.reportsDirectory);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.stdOut = new ByteArrayOutputStream();
        this.newOut = new PrintStream(this.stdOut);
        this.oldOut = System.out;
        TeeStream tee = new TeeStream(this.oldOut, this.newOut);
        System.setOut(tee);
        this.stdErr = new ByteArrayOutputStream();
        this.newErr = new PrintStream(this.stdErr);
        this.oldErr = System.err;
        tee = new TeeStream(this.oldErr, this.newErr);
        System.setErr(tee);
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.testStarting(report);
            }
            catch (Exception e) {
                this.handleReporterException("testStarting", e);
            }
        }
    }

    public void testSucceeded(ReportEntry report) {
        this.resetStreams();
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.testSucceeded(report);
            }
            catch (Exception e) {
                this.handleReporterException("testSucceeded", e);
            }
        }
    }

    public void testError(ReportEntry reportEntry) {
        this.testFailed(reportEntry, "error");
    }

    public void testFailed(ReportEntry reportEntry) {
        this.testFailed(reportEntry, "failure");
    }

    private void testFailed(ReportEntry reportEntry, String typeError) {
        String stdOutLog = this.stdOut.toString();
        String stdErrLog = this.stdErr.toString();
        this.resetStreams();
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                if ("failure".equals(typeError)) {
                    reporter.testFailed(reportEntry, stdOutLog, stdErrLog);
                    continue;
                }
                reporter.testError(reportEntry, stdOutLog, stdErrLog);
            }
            catch (Exception e) {
                this.handleReporterException("testFailed", e);
            }
        }
    }

    private void resetStreams() {
        System.setOut(this.oldOut);
        System.setErr(this.oldErr);
        this.newOut.close();
        this.newErr.close();
    }

    public void dispose() {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter report = (Reporter)it.next();
            try {
                report.dispose();
            }
            catch (Exception e) {
                this.handleReporterException("dispose", e);
            }
        }
    }

    public int getNbErrors() {
        return this.errors;
    }

    public int getNbFailures() {
        return this.failures;
    }

    public int getNbTests() {
        return this.completedCount;
    }

    private void handleReporterException(String reporterMethod, Exception e) {
        String reporterThrewException = Surefire.getResources().getString("reporterThrew");
        MessageFormat msgFmt = new MessageFormat(reporterThrewException);
        Object[] args = new Object[]{reporterMethod};
        String stringToPrint = msgFmt.format(args);
        System.err.println(stringToPrint);
        e.printStackTrace(System.err);
    }
}

