package org.apache.maven.surefire.util;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.PrintStream;

/**
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: TeeStream.java 510866 2007-02-23 08:13:49Z brett $
 */
public class TeeStream
    extends PrintStream
{
    private PrintStream tee;

    public TeeStream( PrintStream out1, PrintStream out2 )
    {
        super( out1 );

        this.tee = out2;
    }

    public void write( byte[] buf, int off, int len )
    {
        try
        {
            super.write( buf, off, len );

            tee.write( buf, off, len );
        }
        catch ( Exception e )
        {
        }
    }

    public void close()
    {
        super.close();

        tee.close();
    }

    public void flush()
    {
        super.flush();

        tee.flush();
    }
}

