/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.util.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public class XMLReporter
extends AbstractReporter {
    private static final String LS = System.getProperty("line.separator");
    private File reportsDirectory;
    private List results = Collections.synchronizedList(new ArrayList());

    public XMLReporter(File reportsDirectory, Boolean trimStackTrace) {
        super(trimStackTrace);
        this.reportsDirectory = reportsDirectory;
    }

    public void writeMessage(String message) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSetCompleted(ReportEntry report) throws ReporterException {
        super.testSetCompleted(report);
        long runTime = System.currentTimeMillis() - this.testSetStartTime;
        Xpp3Dom testSuite = this.createTestElement("testsuite", report, runTime);
        this.showProperties(testSuite);
        testSuite.setAttribute("tests", String.valueOf(this.getNumTests()));
        testSuite.setAttribute("errors", String.valueOf(this.getNumErrors()));
        testSuite.setAttribute("skipped", String.valueOf(this.getNumSkipped()));
        testSuite.setAttribute("failures", String.valueOf(this.getNumFailures()));
        Iterator i = this.results.iterator();
        while (i.hasNext()) {
            Xpp3Dom testcase = (Xpp3Dom)i.next();
            testSuite.addChild(testcase);
        }
        File reportFile = new File(this.reportsDirectory, "TEST-" + report.getName() + ".xml");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8")));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + LS);
            Xpp3DomWriter.write((XMLWriter)new PrettyPrintXMLWriter(writer), (Xpp3Dom)testSuite);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new ReporterException("Unable to use UTF-8 encoding", e);
                catch (FileNotFoundException e2) {
                    throw new ReporterException("Unable to create file: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private String getReportName(ReportEntry report) {
        String reportName = report.getName().indexOf("(") > 0 ? report.getName().substring(0, report.getName().indexOf("(")) : report.getName();
        return reportName;
    }

    public void testSucceeded(ReportEntry report) {
        super.testSucceeded(report);
        long runTime = this.endTime - this.startTime;
        Xpp3Dom testCase = this.createTestElement("testcase", report, runTime);
        this.results.add(testCase);
    }

    private Xpp3Dom createTestElement(String name, ReportEntry report, long runTime) {
        Xpp3Dom testCase = new Xpp3Dom(name);
        testCase.setAttribute("name", this.getReportName(report));
        if (report.getGroup() != null) {
            testCase.setAttribute("group", report.getGroup());
        }
        testCase.setAttribute("time", this.elapsedTimeAsString(runTime));
        return testCase;
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        super.testError(report, stdOut, stdErr);
        this.writeTestProblems(report, stdOut, stdErr, "error");
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        super.testFailed(report, stdOut, stdErr);
        this.writeTestProblems(report, stdOut, stdErr, "failure");
    }

    private void writeTestProblems(ReportEntry report, String stdOut, String stdErr, String name) {
        long runTime = this.endTime - this.startTime;
        Xpp3Dom testCase = this.createTestElement("testcase", report, runTime);
        Xpp3Dom element = this.createElement(testCase, name);
        String stackTrace = this.getStackTrace(report);
        Throwable t = report.getStackTraceWriter().getThrowable();
        if (t != null) {
            String message = t.getMessage();
            if (message != null && message.trim().length() > 0) {
                element.setAttribute("message", XMLReporter.escapeAttribute(message));
                element.setAttribute("type", stackTrace.substring(0, stackTrace.indexOf(":")));
            } else {
                element.setAttribute("type", new StringTokenizer(stackTrace).nextToken());
            }
        }
        element.setValue(stackTrace);
        this.addOutputStreamElement(stdOut, "system-out", testCase);
        this.addOutputStreamElement(stdErr, "system-err", testCase);
        this.results.add(testCase);
    }

    private void addOutputStreamElement(String stdOut, String name, Xpp3Dom testCase) {
        if (stdOut != null && stdOut.trim().length() > 0) {
            this.createElement(testCase, name).setValue(stdOut);
        }
    }

    private Xpp3Dom createElement(Xpp3Dom element, String name) {
        Xpp3Dom component = new Xpp3Dom(name);
        element.addChild(component);
        return component;
    }

    private void showProperties(Xpp3Dom testSuite) {
        Xpp3Dom properties = this.createElement(testSuite, "properties");
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                String value = systemProperties.getProperty(key);
                if (value == null) {
                    value = "null";
                }
                Xpp3Dom property = this.createElement(properties, "property");
                property.setAttribute("name", key);
                property.setAttribute("value", XMLReporter.escapeAttribute(value));
            }
        }
    }

    private static String escapeAttribute(String attribute) {
        String s = StringUtils.replace((String)attribute, (String)"<", (String)"&lt;");
        s = StringUtils.replace((String)s, (String)">", (String)"&gt;");
        return s;
    }

    public Iterator getResults() {
        return this.results.iterator();
    }

    public void reset() {
        this.results.clear();
        super.reset();
    }
}

