/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.PrintStream;
import java.util.Properties;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;

public class SurefireStarter {
    private static final int NO_TESTS = 254;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private static final String RESULTS_ERRORS = "errors";
    private static final String RESULTS_COMPLETED_COUNT = "completedCount";
    private static final String RESULTS_FAILURES = "failures";
    private static final String RESULTS_SKIPPED = "skipped";

    public SurefireStarter(StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration) {
        this.providerConfiguration = providerConfiguration;
        this.startupConfiguration = startupConfiguration;
    }

    public RunResult runSuitesInProcess(Object testSet) throws SurefireExecutionException {
        StartupConfiguration starterConfiguration = this.startupConfiguration;
        ClasspathConfiguration classpathConfiguration = starterConfiguration.getClasspathConfiguration();
        ClassLoader testsClassLoader = classpathConfiguration.createTestClassLoaderConditionallySystem(starterConfiguration.useSystemClassLoader());
        ClassLoader surefireClassLoader = classpathConfiguration.createSurefireClassLoader(testsClassLoader);
        return this.invokeProvider(testSet, testsClassLoader, surefireClassLoader);
    }

    public RunResult runSuitesInProcess() throws SurefireExecutionException {
        ClassLoader testsClassLoader = this.createInProcessTestClassLoader();
        ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        ClassLoader surefireClassLoader = classpathConfiguration.createSurefireClassLoader(testsClassLoader);
        return this.invokeProvider(null, testsClassLoader, surefireClassLoader);
    }

    private ClassLoader createInProcessTestClassLoader() throws SurefireExecutionException {
        ClassLoader testsClassLoader;
        ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        String testClassPath = classpathConfiguration.getTestClasspath().getClassPathAsString();
        System.setProperty("surefire.test.class.path", testClassPath);
        if (this.startupConfiguration.isManifestOnlyJarRequestedAndUsable()) {
            testsClassLoader = this.getClass().getClassLoader();
            System.setProperty("surefire.real.class.path", System.getProperty("java.class.path"));
            System.setProperty("java.class.path", testClassPath);
        } else {
            testsClassLoader = classpathConfiguration.createTestClassLoader();
        }
        return testsClassLoader;
    }

    public void updateResultsProperties(RunResult runResult, Properties results) {
        results.setProperty(RESULTS_ERRORS, String.valueOf(runResult.getErrors()));
        results.setProperty(RESULTS_COMPLETED_COUNT, String.valueOf(runResult.getCompletedCount()));
        results.setProperty(RESULTS_FAILURES, String.valueOf(runResult.getFailures()));
        results.setProperty(RESULTS_SKIPPED, String.valueOf(runResult.getSkipped()));
    }

    private RunResult invokeProvider(Object testSet, ClassLoader testsClassLoader, ClassLoader surefireClassLoader) {
        PrintStream orgSystemOut = System.out;
        PrintStream orgSystemErr = System.err;
        ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, surefireClassLoader);
        SurefireProvider provider = providerFactory.createProvider(testsClassLoader);
        try {
            RunResult runResult = provider.invoke(testSet);
            return runResult;
        }
        catch (TestSetFailedException e) {
            throw new RuntimeException(e);
        }
        catch (ReporterException e) {
            throw new RuntimeException(e);
        }
        finally {
            System.setOut(orgSystemOut);
            System.setErr(orgSystemErr);
        }
    }

    public int processRunCount(RunResult runCount) throws SurefireExecutionException {
        if (runCount.getCompletedCount() == 0 && this.providerConfiguration.isFailIfNoTests().booleanValue()) {
            return 254;
        }
        return runCount.getBooterCode();
    }
}

