/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.apache.maven.surefire.junit.TestListenerInvocationHandler;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.testset.AbstractTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;

public final class JUnitTestSet
extends AbstractTestSet {
    public static final String TEST_CASE = "junit.framework.TestCase";
    public static final String TEST_RESULT = "junit.framework.TestResult";
    public static final String TEST_LISTENER = "junit.framework.TestListener";
    public static final String TEST = "junit.framework.Test";
    public static final String ADD_LISTENER_METHOD = "addListener";
    public static final String RUN_METHOD = "run";
    public static final String COUNT_TEST_CASES_METHOD = "countTestCases";
    public static final String SETUP_METHOD = "setUp";
    public static final String TEARDOWN_METHOD = "tearDown";
    private static final String TEST_SUITE = "junit.framework.TestSuite";
    private Class[] interfacesImplementedByDynamicProxy;
    private Class testResultClass;
    private Method addListenerMethod;
    private Method countTestCasesMethod;
    private Method runMethod;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;

    public JUnitTestSet(Class testClass) throws TestSetFailedException {
        super(testClass);
        this.processTestClass();
    }

    private void processTestClass() throws TestSetFailedException {
        try {
            Class testClass = this.getTestClass();
            ClassLoader loader = testClass.getClassLoader();
            this.testResultClass = loader.loadClass(TEST_RESULT);
            Class<?> testListenerInterface = loader.loadClass(TEST_LISTENER);
            Class<?> testInterface = loader.loadClass(TEST);
            this.interfacesImplementedByDynamicProxy = new Class[1];
            this.interfacesImplementedByDynamicProxy[0] = testListenerInterface;
            Class[] addListenerParamTypes = this.interfacesImplementedByDynamicProxy;
            this.addListenerMethod = this.testResultClass.getMethod(ADD_LISTENER_METHOD, addListenerParamTypes);
            if (testInterface.isAssignableFrom(testClass)) {
                this.countTestCasesMethod = testInterface.getMethod(COUNT_TEST_CASES_METHOD, EMPTY_CLASS_ARRAY);
                this.runMethod = testInterface.getMethod(RUN_METHOD, this.testResultClass);
            } else {
                this.countTestCasesMethod = testClass.getMethod(COUNT_TEST_CASES_METHOD, EMPTY_CLASS_ARRAY);
                this.runMethod = testClass.getMethod(RUN_METHOD, this.testResultClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException("JUnit classes not available", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Class is not a JUnit TestCase", (Throwable)e);
        }
    }

    private static Object constructTestObject(Class testClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException, ClassNotFoundException {
        Object testObject = JUnitTestSet.createInstanceFromSuiteMethod(testClass);
        if (testObject == null && testClass.getClassLoader().loadClass(TEST_CASE).isAssignableFrom(testClass)) {
            Class[] constructorParamTypes = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = JUnitTestSet.class$("java.lang.Class")) : class$java$lang$Class};
            Constructor<?> constructor = testClass.getClassLoader().loadClass(TEST_SUITE).getConstructor(constructorParamTypes);
            Object[] constructorParams = new Object[]{testClass};
            testObject = constructor.newInstance(constructorParams);
        }
        if (testObject == null) {
            Constructor testConstructor = JUnitTestSet.getTestConstructor(testClass);
            testObject = testConstructor.getParameterTypes().length == 0 ? testConstructor.newInstance(EMPTY_OBJECT_ARRAY) : testConstructor.newInstance(testClass.getName());
        }
        return testObject;
    }

    private static Object createInstanceFromSuiteMethod(Class testClass) throws IllegalAccessException, InvocationTargetException {
        Object testObject = null;
        try {
            Method suiteMethod = testClass.getMethod("suite", EMPTY_CLASS_ARRAY);
            if (Modifier.isPublic(suiteMethod.getModifiers()) && Modifier.isStatic(suiteMethod.getModifiers())) {
                testObject = suiteMethod.invoke(null, (Object[])EMPTY_CLASS_ARRAY);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return testObject;
    }

    public void execute(ReporterManager reportManager, ClassLoader loader) throws TestSetFailedException {
        Class testClass = this.getTestClass();
        try {
            Object testObject = JUnitTestSet.constructTestObject(testClass);
            Object instanceOfTestResult = this.testResultClass.newInstance();
            TestListenerInvocationHandler invocationHandler = new TestListenerInvocationHandler(reportManager, instanceOfTestResult, loader);
            Object testListener = Proxy.newProxyInstance(loader, this.interfacesImplementedByDynamicProxy, (InvocationHandler)invocationHandler);
            Object[] addTestListenerParams = new Object[]{testListener};
            this.addListenerMethod.invoke(instanceOfTestResult, addTestListenerParams);
            Object[] runParams = new Object[]{instanceOfTestResult};
            this.runMethod.invoke(testObject, runParams);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(testClass.getName(), e.getTargetException());
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException("JUnit classes not available", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Class is not a JUnit TestCase", (Throwable)e);
        }
    }

    public int getTestCount() throws TestSetFailedException {
        Class testClass = this.getTestClass();
        try {
            Object testObject = JUnitTestSet.constructTestObject(testClass);
            Integer integer = (Integer)this.countTestCasesMethod.invoke(testObject, (Object[])EMPTY_CLASS_ARRAY);
            return integer;
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(testClass.getName(), e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException("JUnit classes not available", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Class is not a JUnit TestCase", (Throwable)e);
        }
    }

    private static Constructor getTestConstructor(Class testClass) throws NoSuchMethodException {
        Constructor constructor;
        try {
            constructor = testClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = JUnitTestSet.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoSuchMethodException e) {
            constructor = testClass.getConstructor(EMPTY_CLASS_ARRAY);
        }
        return constructor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

