/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.surefire.api.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.util.internal.TestClassMethodNameUtils;

public class TestListenerInvocationHandler
implements InvocationHandler {
    private static final String START_TEST = "startTest";
    private static final String ADD_FAILURE = "addFailure";
    private static final String ADD_ERROR = "addError";
    private static final String END_TEST = "endTest";
    private final Set<FailedTest> failedTestsSet = new HashSet<FailedTest>();
    private RunListener reporter;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_STRING_ARRAY = new Object[0];

    public TestListenerInvocationHandler(RunListener reporter) {
        if (reporter == null) {
            throw new NullPointerException("reporter is null");
        }
        this.reporter = reporter;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "startTest": {
                this.handleStartTest(args);
                break;
            }
            case "addError": {
                this.handleAddError(args);
                break;
            }
            case "addFailure": {
                this.handleAddFailure(args);
                break;
            }
            case "endTest": {
                this.handleEndTest(args);
                break;
            }
        }
        return null;
    }

    private void handleStartTest(Object[] args) {
        SimpleReportEntry report = TestListenerInvocationHandler.createStartEndReportEntry(args);
        this.reporter.testStarting((ReportEntry)report);
    }

    private void handleAddError(Object[] args) throws ReflectiveOperationException {
        ReportEntry report = TestListenerInvocationHandler.toReportEntryWithException(args);
        this.reporter.testError(report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private static LegacyPojoStackTraceWriter toStackTraceWriter(Object[] args) throws ReflectiveOperationException {
        String testName;
        try {
            Method m = args[0].getClass().getMethod("getName", EMPTY_CLASS_ARRAY);
            testName = (String)m.invoke(args[0], EMPTY_STRING_ARRAY);
        }
        catch (NoSuchMethodException e) {
            testName = "UNKNOWN";
        }
        return new LegacyPojoStackTraceWriter(args[0].getClass().getName(), testName, (Throwable)args[1]);
    }

    private void handleAddFailure(Object[] args) throws ReflectiveOperationException {
        ReportEntry report = TestListenerInvocationHandler.toReportEntryWithException(args);
        this.reporter.testFailed(report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private void handleEndTest(Object[] args) {
        boolean testHadFailed = this.failedTestsSet.remove(new FailedTest(args[0], Thread.currentThread()));
        if (!testHadFailed) {
            SimpleReportEntry report = TestListenerInvocationHandler.createStartEndReportEntry(args);
            this.reporter.testSucceeded((ReportEntry)report);
        }
    }

    private static ReportEntry toReportEntryWithException(Object[] args) throws ReflectiveOperationException {
        String description = args[0].toString();
        String className = TestClassMethodNameUtils.extractClassName((String)description);
        String methodName = TestClassMethodNameUtils.extractMethodName((String)description);
        LegacyPojoStackTraceWriter stackTraceWriter = TestListenerInvocationHandler.toStackTraceWriter(args);
        return SimpleReportEntry.withException((String)className, null, (String)methodName, null, (StackTraceWriter)stackTraceWriter);
    }

    private static SimpleReportEntry createStartEndReportEntry(Object[] args) {
        String description = args[0].toString();
        return new SimpleReportEntry(TestClassMethodNameUtils.extractClassName((String)description), null, TestClassMethodNameUtils.extractMethodName((String)description), null);
    }

    private static class FailedTest {
        private Object testThatFailed;
        private Thread threadOnWhichTestFailed;

        FailedTest(Object testThatFailed, Thread threadOnWhichTestFailed) {
            if (testThatFailed == null) {
                throw new NullPointerException("testThatFailed is null");
            }
            if (threadOnWhichTestFailed == null) {
                throw new NullPointerException("threadOnWhichTestFailed is null");
            }
            this.testThatFailed = testThatFailed;
            this.threadOnWhichTestFailed = threadOnWhichTestFailed;
        }

        public boolean equals(Object obj) {
            boolean retVal = true;
            if (obj == null || this.getClass() != obj.getClass()) {
                retVal = false;
            } else {
                FailedTest ft = (FailedTest)obj;
                if (ft.testThatFailed != this.testThatFailed) {
                    retVal = false;
                } else if (!ft.threadOnWhichTestFailed.equals(this.threadOnWhichTestFailed)) {
                    retVal = false;
                }
            }
            return retVal;
        }

        public int hashCode() {
            return this.threadOnWhichTestFailed.hashCode();
        }
    }
}

