/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.junit4.JUnit4TestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DefaultDirectoryScanner;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4Provider
extends AbstractProvider {
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final List<RunListener> customRunListeners;
    private final JUnit4TestChecker jUnit4TestChecker;
    private final String requestedTestMethod;
    private TestsToRun testsToRun;
    private final ProviderParameters providerParameters;

    public JUnit4Provider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScanner = booterParameters.getDirectoryScanner();
        this.customRunListeners = JUnit4RunListenerFactory.createCustomListeners(booterParameters.getProviderProperties().getProperty("listener"));
        this.jUnit4TestChecker = new JUnit4TestChecker(this.testClassLoader);
        this.requestedTestMethod = booterParameters.getTestRequest().getRequestedTestMethod();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        this.upgradeCheck();
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        Reporter reporter = reporterFactory.createReporter();
        JUnit4RunListener jUnit4TestSetReporter = new JUnit4RunListener(reporter);
        RunNotifier runNotifer = this.getRunNotifer(jUnit4TestSetReporter, this.customRunListeners);
        for (Class clazz : this.testsToRun.getLocatedClasses()) {
            this.executeTestSet(clazz, reporter, this.testClassLoader, runNotifer);
        }
        this.closeRunNotifer(jUnit4TestSetReporter, this.customRunListeners);
        return reporterFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestSet(Class clazz, Reporter reporter, ClassLoader classLoader, RunNotifier listeners) throws ReporterException, TestSetFailedException {
        SimpleReportEntry report = new SimpleReportEntry(((Object)((Object)this)).getClass().getName(), clazz.getName());
        reporter.testSetStarting((ReportEntry)report);
        try {
            JUnit4TestSet.execute(clazz, listeners, this.requestedTestMethod);
        }
        catch (TestSetFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.testError((ReportEntry)new SimpleReportEntry(report.getSourceName(), report.getName(), (StackTraceWriter)new PojoStackTraceWriter(report.getSourceName(), report.getName(), e)));
        }
        finally {
            reporter.testSetCompleted((ReportEntry)report);
        }
    }

    private RunNotifier getRunNotifer(RunListener main, List<RunListener> others) {
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.addListener(main);
        for (RunListener listener : others) {
            fNotifier.addListener(listener);
        }
        return fNotifier;
    }

    private void closeRunNotifer(RunListener main, List<RunListener> others) {
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.removeListener(main);
        for (RunListener listener : others) {
            fNotifier.removeListener(listener);
        }
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    private TestsToRun scanClassPath() {
        return this.directoryScanner.locateTestClasses(this.testClassLoader, (ScannerFilter)this.jUnit4TestChecker);
    }

    private void upgradeCheck() throws TestSetFailedException {
        if (this.isJunit4UpgradeCheck() && ((DefaultDirectoryScanner)this.directoryScanner).getClassesSkippedByValidation().size() > 0) {
            StringBuilder reason = new StringBuilder();
            reason.append("Updated check failed\n");
            reason.append("There are tests that would be run with junit4 / surefire 2.6 but not with [2.7,):\n");
            for (Class testClass : ((DefaultDirectoryScanner)this.directoryScanner).getClassesSkippedByValidation()) {
                reason.append("   ");
                reason.append(testClass.getCanonicalName());
                reason.append("\n");
            }
            throw new TestSetFailedException(reason.toString());
        }
    }

    private boolean isJunit4UpgradeCheck() {
        String property = System.getProperty("surefire.junit4.upgradecheck");
        return property != null;
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }
}

