/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class ClassDemarcatingRunner
extends Runner {
    private final Runner target;
    private final Class testClass;
    private static final ThreadLocal<Class> currentlyRunning = new ThreadLocal();

    public ClassDemarcatingRunner(Runner target, Class testClass) {
        this.target = target;
        this.testClass = testClass;
    }

    public Description getDescription() {
        return this.target.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        currentlyRunning.set(this.testClass);
        try {
            this.target.run(notifier);
        }
        finally {
            currentlyRunning.remove();
        }
    }

    public static String getCurrentTestClass() {
        Class aClass = currentlyRunning.get();
        return aClass != null ? aClass.getName() : null;
    }
}

