/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.report.ConsoleLogger;

final class InvokerStrategy
extends SchedulingStrategy {
    private final Queue<Thread> activeThreads = new ConcurrentLinkedQueue<Thread>();

    protected InvokerStrategy(ConsoleLogger logger) {
        super(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable task) {
        if (this.canSchedule()) {
            Thread currentThread = Thread.currentThread();
            try {
                this.activeThreads.add(currentThread);
                task.run();
            }
            finally {
                this.activeThreads.remove(currentThread);
            }
        }
    }

    protected boolean stop() {
        return this.disable();
    }

    protected boolean stopNow() {
        boolean stopped = this.disable();
        Thread activeThread = this.activeThreads.poll();
        while (activeThread != null) {
            activeThread.interrupt();
            activeThread = this.activeThreads.poll();
        }
        return stopped;
    }

    public boolean hasSharedThreadPool() {
        return false;
    }

    public boolean finished() throws InterruptedException {
        return this.disable();
    }

    public boolean destroy() {
        return this.stop();
    }
}

