/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.surefire.junitcore.JUnitCoreTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestsToRun {
    final Class[] locatedClasses;
    final int totalTests;
    Map<String, JUnitCoreTestSet> testSets;

    public TestsToRun(Class ... locatedClasses) throws TestSetFailedException {
        this.locatedClasses = locatedClasses;
        this.testSets = new HashMap<String, JUnitCoreTestSet>();
        int testCount = 0;
        for (int i = 0; i < locatedClasses.length; ++i) {
            Class testClass = locatedClasses[i];
            JUnitCoreTestSet testSet = new JUnitCoreTestSet(testClass);
            if (this.testSets.containsKey(testSet.getName())) {
                throw new TestSetFailedException("Duplicate test set '" + testSet.getName() + "'");
            }
            this.testSets.put(testSet.getName(), testSet);
            ++testCount;
        }
        this.totalTests = testCount;
    }

    public Map<String, JUnitCoreTestSet> getTestSets() {
        return Collections.unmodifiableMap(this.testSets);
    }

    public int size() {
        return this.testSets.size();
    }

    public Class[] getLocatedClasses() {
        return this.locatedClasses;
    }

    public JUnitCoreTestSet getTestSet(String name) {
        return this.testSets.get(name);
    }
}

