/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.report.ConsoleStream;

final class InvokerStrategy
extends SchedulingStrategy {
    private final Queue<Thread> activeThreads = new ConcurrentLinkedQueue<Thread>();

    protected InvokerStrategy(ConsoleStream logger) {
        super(logger);
    }

    @Override
    public void schedule(Runnable task) {
        if (this.canSchedule()) {
            Thread currentThread = Thread.currentThread();
            try {
                this.activeThreads.add(currentThread);
                task.run();
            }
            finally {
                this.activeThreads.remove(currentThread);
            }
        }
    }

    @Override
    protected boolean stop() {
        return this.disable();
    }

    @Override
    protected boolean stopNow() {
        boolean stopped = this.disable();
        Thread activeThread = this.activeThreads.poll();
        while (activeThread != null) {
            activeThread.interrupt();
            activeThread = this.activeThreads.poll();
        }
        return stopped;
    }

    @Override
    public boolean hasSharedThreadPool() {
        return false;
    }

    @Override
    public boolean finished() throws InterruptedException {
        return this.disable();
    }

    @Override
    public boolean destroy() {
        return this.stop();
    }
}

