/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.surefire.report.ReportTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportTestSuite {
    private final List<ReportTestCase> testCases = new ArrayList<ReportTestCase>();
    private int numberOfErrors;
    private int numberOfFailures;
    private int numberOfSkipped;
    private int numberOfFlakes;
    private Integer numberOfTests;
    private String name;
    private String fullClassName;
    private String packageName;
    private float timeElapsed;

    public List<ReportTestCase> getTestCases() {
        return this.testCases;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public ReportTestSuite setNumberOfErrors(int numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
        return this;
    }

    public ReportTestSuite incrementNumberOfErrors() {
        ++this.numberOfErrors;
        return this;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public ReportTestSuite setNumberOfFailures(int numberOfFailures) {
        this.numberOfFailures = numberOfFailures;
        return this;
    }

    public ReportTestSuite incrementNumberOfFailures() {
        ++this.numberOfFailures;
        return this;
    }

    public int getNumberOfSkipped() {
        return this.numberOfSkipped;
    }

    public ReportTestSuite setNumberOfSkipped(int numberOfSkipped) {
        this.numberOfSkipped = numberOfSkipped;
        return this;
    }

    public ReportTestSuite incrementNumberOfSkipped() {
        ++this.numberOfSkipped;
        return this;
    }

    public int getNumberOfFlakes() {
        return this.numberOfFlakes;
    }

    public ReportTestSuite setNumberOfFlakes(int numberOfFlakes) {
        this.numberOfFlakes = numberOfFlakes;
        return this;
    }

    public ReportTestSuite incrementNumberOfFlakes() {
        ++this.numberOfFlakes;
        return this;
    }

    public int getNumberOfTests() {
        if (this.numberOfTests != null) {
            return this.numberOfTests;
        }
        if (this.testCases != null) {
            return this.testCases.size();
        }
        return 0;
    }

    public ReportTestSuite setNumberOfTests(int numberOfTests) {
        this.numberOfTests = numberOfTests;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ReportTestSuite setName(String name) {
        this.name = name;
        return this;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public ReportTestSuite setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
        int lastDotPosition = fullClassName.lastIndexOf(".");
        this.name = fullClassName.substring(lastDotPosition + 1, fullClassName.length());
        this.packageName = lastDotPosition == -1 ? "" : fullClassName.substring(0, lastDotPosition);
        return this;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ReportTestSuite setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public float getTimeElapsed() {
        return this.timeElapsed;
    }

    public ReportTestSuite setTimeElapsed(float timeElapsed) {
        this.timeElapsed = timeElapsed;
        return this;
    }

    ReportTestSuite setTestCases(List<ReportTestCase> testCases) {
        this.testCases.clear();
        this.testCases.addAll(testCases);
        return this;
    }

    public String toString() {
        return this.fullClassName + " [" + this.getNumberOfTests() + "/" + this.getNumberOfFailures() + "/" + this.getNumberOfErrors() + "/" + this.getNumberOfSkipped() + "]";
    }
}

