/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.junit;

import java.util.Iterator;
import org.apache.maven.surefire.shadefire.common.junit3.JUnit3Reflector;
import org.apache.maven.surefire.shadefire.common.junit3.JUnit3TestChecker;
import org.apache.maven.surefire.shadefire.junit.JUnitTestSet;
import org.apache.maven.surefire.shadefire.junit.PojoAndJUnit3Checker;
import org.apache.maven.surefire.shadefire.junit.PojoTestSet;
import org.apache.maven.surefire.shadefire.junit.SurefireTestSet;
import org.apache.maven.surefire.shadefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.shadefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.shadefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.shadefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.shadefire.report.ReporterException;
import org.apache.maven.surefire.shadefire.report.ReporterFactory;
import org.apache.maven.surefire.shadefire.report.RunListener;
import org.apache.maven.surefire.shadefire.report.SimpleReportEntry;
import org.apache.maven.surefire.shadefire.suite.RunResult;
import org.apache.maven.surefire.shadefire.testset.TestSetFailedException;
import org.apache.maven.surefire.shadefire.util.DirectoryScanner;
import org.apache.maven.surefire.shadefire.util.ReflectionUtils;
import org.apache.maven.surefire.shadefire.util.RunOrderCalculator;
import org.apache.maven.surefire.shadefire.util.TestsToRun;

public class JUnit3Provider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final PojoAndJUnit3Checker testChecker;
    private final JUnit3TestChecker jUnit3TestChecker;
    private final JUnit3Reflector reflector;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private TestsToRun testsToRun;

    public JUnit3Provider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScanner = booterParameters.getDirectoryScanner();
        this.runOrderCalculator = booterParameters.getRunOrderCalculator();
        this.reflector = new JUnit3Reflector(this.testClassLoader);
        this.jUnit3TestChecker = new JUnit3TestChecker(this.testClassLoader);
        this.testChecker = new PojoAndJUnit3Checker(this.jUnit3TestChecker);
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)forkTestSet);
        }
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        RunListener reporter = reporterFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((Object)reporter));
        String smClassName = System.getProperty("surefire.security.manager");
        if (smClassName != null) {
            SecurityManager securityManager = (SecurityManager)ReflectionUtils.instantiate(this.getClass().getClassLoader(), smClassName);
            System.setSecurityManager(securityManager);
        }
        Iterator iter = this.testsToRun.iterator();
        while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            SurefireTestSet surefireTestSet = this.createTestSet(clazz);
            this.executeTestSet(surefireTestSet, reporter, this.testClassLoader);
        }
        return reporterFactory.close();
    }

    private SurefireTestSet createTestSet(Class clazz) throws TestSetFailedException {
        return this.reflector.isJUnit3Available() && this.jUnit3TestChecker.accept(clazz) ? new JUnitTestSet(clazz, this.reflector) : new PojoTestSet(clazz);
    }

    private void executeTestSet(SurefireTestSet testSet, RunListener reporter, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        SimpleReportEntry report = new SimpleReportEntry(this.getClass().getName(), testSet.getName());
        reporter.testSetStarting(report);
        testSet.execute(reporter, classLoader);
        reporter.testSetCompleted(report);
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanResult = this.directoryScanner.locateTestClasses(this.testClassLoader, this.testChecker);
        return this.runOrderCalculator.orderTestClasses(scanResult);
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }
}

