/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.plugin.surefire.runorder.RunEntryStatisticsMap;
import org.apache.maven.surefire.shadefire.testset.RunOrderParameters;
import org.apache.maven.surefire.shadefire.util.RunOrder;
import org.apache.maven.surefire.shadefire.util.RunOrderCalculator;
import org.apache.maven.surefire.shadefire.util.TestsToRun;

public class DefaultRunOrderCalculator
implements RunOrderCalculator {
    private final Comparator sortOrder;
    private final RunOrder[] runOrder;
    private final RunOrderParameters runOrderParameters;
    private final int threadCount;

    public DefaultRunOrderCalculator(RunOrderParameters runOrderParameters, int threadCount) {
        this.runOrderParameters = runOrderParameters;
        this.threadCount = threadCount;
        this.runOrder = runOrderParameters.getRunOrder();
        this.sortOrder = this.runOrder.length > 0 ? this.getSortOrderComparator(this.runOrder[0]) : null;
    }

    public TestsToRun orderTestClasses(TestsToRun scannedClasses) {
        ArrayList<Class> result = new ArrayList<Class>(Arrays.asList(scannedClasses.getLocatedClasses()));
        this.orderTestClasses(result, this.runOrder.length != 0 ? this.runOrder[0] : null);
        return new TestsToRun(result);
    }

    private void orderTestClasses(List testClasses, RunOrder runOrder) {
        if (RunOrder.RANDOM.equals(runOrder)) {
            Collections.shuffle(testClasses);
        } else if (RunOrder.FAILEDFIRST.equals(runOrder)) {
            RunEntryStatisticsMap runEntryStatisticsMap = RunEntryStatisticsMap.fromFile(this.runOrderParameters.getRunStatisticsFile());
            List prioritized = runEntryStatisticsMap.getPrioritizedTestsByFailureFirst(testClasses);
            testClasses.clear();
            testClasses.addAll(prioritized);
        } else if (RunOrder.BALANCED.equals(runOrder)) {
            RunEntryStatisticsMap runEntryStatisticsMap = RunEntryStatisticsMap.fromFile(this.runOrderParameters.getRunStatisticsFile());
            List prioritized = runEntryStatisticsMap.getPrioritizedTestsClassRunTime(testClasses, this.threadCount);
            testClasses.clear();
            testClasses.addAll(prioritized);
        } else if (this.sortOrder != null) {
            Collections.sort(testClasses, this.sortOrder);
        }
    }

    private Comparator getSortOrderComparator(RunOrder runOrder) {
        if (RunOrder.ALPHABETICAL.equals(runOrder)) {
            return this.getAlphabeticalComparator();
        }
        if (RunOrder.REVERSE_ALPHABETICAL.equals(runOrder)) {
            return this.getReverseAlphabeticalComparator();
        }
        if (RunOrder.HOURLY.equals(runOrder)) {
            int hour = Calendar.getInstance().get(11);
            return hour % 2 == 0 ? this.getAlphabeticalComparator() : this.getReverseAlphabeticalComparator();
        }
        return null;
    }

    private Comparator getReverseAlphabeticalComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Class)o2).getName().compareTo(((Class)o1).getName());
            }
        };
    }

    private Comparator getAlphabeticalComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Class)o1).getName().compareTo(((Class)o2).getName());
            }
        };
    }
}

