/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class RunOrder {
    public static final RunOrder ALPHABETICAL = new RunOrder("alphabetical");
    public static final RunOrder FILESYSTEM = new RunOrder("filesystem");
    public static final RunOrder HOURLY = new RunOrder("hourly");
    public static final RunOrder RANDOM = new RunOrder("random");
    public static final RunOrder REVERSE_ALPHABETICAL = new RunOrder("reversealphabetical");
    public static final RunOrder BALANCED = new RunOrder("balanced");
    public static final RunOrder FAILEDFIRST = new RunOrder("failedfirst");
    public static final RunOrder[] DEFAULT = new RunOrder[]{FILESYSTEM};
    private final String name;

    public static RunOrder[] valueOfMulti(String values) {
        ArrayList<RunOrder> result = new ArrayList<RunOrder>();
        if (values != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(values, ",");
            while (stringTokenizer.hasMoreTokens()) {
                result.add(RunOrder.valueOf(stringTokenizer.nextToken()));
            }
        }
        return result.toArray(new RunOrder[result.size()]);
    }

    public static RunOrder valueOf(String name) {
        if (name == null) {
            return null;
        }
        RunOrder[] runOrders = RunOrder.values();
        for (int i = 0; i < runOrders.length; ++i) {
            if (!runOrders[i].matches(name)) continue;
            return runOrders[i];
        }
        StringBuffer errorMessage = RunOrder.createMessageForMissingRunOrder(name);
        throw new IllegalArgumentException(errorMessage.toString());
    }

    private static StringBuffer createMessageForMissingRunOrder(String name) {
        RunOrder[] runOrders = RunOrder.values();
        StringBuffer message = new StringBuffer();
        message.append("There's no RunOrder with the name ");
        message.append(name);
        message.append(". Please use one of the following RunOrders: ");
        for (int i = 0; i < runOrders.length; ++i) {
            if (i != 0) {
                message.append(", ");
            }
            message.append(runOrders[i]);
        }
        message.append(".");
        return message;
    }

    private static RunOrder[] values() {
        return new RunOrder[]{ALPHABETICAL, FILESYSTEM, HOURLY, RANDOM, REVERSE_ALPHABETICAL, BALANCED, FAILEDFIRST};
    }

    public static String asString(RunOrder[] runOrder) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < runOrder.length; ++i) {
            stringBuffer.append(runOrder[i].name);
            if (i >= runOrder.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private RunOrder(String name) {
        this.name = name;
    }

    private boolean matches(String anotherName) {
        return this.name.equalsIgnoreCase(anotherName);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

