/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.suite.AbstractDirectoryTestSuite;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.TestNGTestSet;
import org.apache.maven.surefire.testset.SurefireTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.ISuiteListener;
import org.testng.ITestListener;
import org.testng.TestNG;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGDirectoryTestSuite
extends AbstractDirectoryTestSuite {
    private String groups;
    private String excludedGroups;
    private boolean parallel;
    private int threadCount;
    private String testSourceDirectory;
    private IAnnotationFinder annotationFinder;

    public TestNGDirectoryTestSuite(File basedir, ArrayList includes, ArrayList excludes, String groups, String excludedGroups, Boolean parallel, Integer threadCount, String testSourceDirectory) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        super(basedir, (List)includes, (List)excludes);
        Class<?> annotationClass;
        this.groups = groups;
        this.excludedGroups = excludedGroups;
        this.parallel = parallel;
        this.threadCount = threadCount;
        this.testSourceDirectory = testSourceDirectory;
        try {
            annotationClass = Class.forName("org.testng.internal.annotations.JDK15AnnotationFinder");
        }
        catch (ClassNotFoundException e) {
            annotationClass = Class.forName("org.testng.internal.annotations.JDK14AnnotationFinder");
        }
        this.annotationFinder = (IAnnotationFinder)annotationClass.newInstance();
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        return super.locateTestSets(classLoader);
    }

    protected SurefireTestSet createTestSet(Class testClass, ClassLoader classLoader) {
        return new TestNGTestSet(testClass);
    }

    public void execute(String testSetName, ReporterManager reporterManager, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        SurefireTestSet testSet = (SurefireTestSet)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        XmlSuite suite = new XmlSuite();
        suite.setParallel(this.parallel);
        suite.setThreadCount(this.threadCount);
        this.createXmlTest(suite, testSet);
        this.executeTestNG(suite, reporterManager, classLoader);
    }

    public void execute(ReporterManager reporterManager, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        XmlSuite suite = new XmlSuite();
        suite.setParallel(this.parallel);
        suite.setThreadCount(this.threadCount);
        Iterator i = this.testSets.values().iterator();
        while (i.hasNext()) {
            SurefireTestSet testSet = (SurefireTestSet)i.next();
            this.createXmlTest(suite, testSet);
        }
        this.executeTestNG(suite, reporterManager, classLoader);
    }

    private void createXmlTest(XmlSuite suite, SurefireTestSet testSet) {
        XmlTest xmlTest = new XmlTest(suite);
        xmlTest.setName(testSet.getName());
        xmlTest.setXmlClasses(Collections.singletonList(new XmlClass(testSet.getTestClass())));
        if (this.groups != null) {
            xmlTest.setIncludedGroups(Arrays.asList(this.groups.split(",")));
        }
        if (this.excludedGroups != null) {
            xmlTest.setExcludedGroups(Arrays.asList(this.excludedGroups.split(",")));
        }
        if ("junit.framework.TestCase".equals(testSet.getTestClass().getSuperclass().getName())) {
            xmlTest.setJUnit(true);
        }
    }

    private void executeTestNG(XmlSuite suite, ReporterManager reporterManager, ClassLoader classLoader) {
        TestNG testNG = new TestNG(false);
        testNG.setVerbose(0);
        testNG.setXmlSuites(Collections.singletonList(suite));
        testNG.setListenerClasses(new ArrayList());
        TestNGReporter reporter = new TestNGReporter(reporterManager, (SurefireTestSuite)this);
        testNG.addListener((ITestListener)reporter);
        testNG.addListener((ISuiteListener)reporter);
        if (this.testSourceDirectory != null) {
            testNG.setSourcePath(this.testSourceDirectory);
        }
        testNG.runSuitesLocally();
    }
}

