/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.util.ResourceBundle;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testng.TestNGStackTraceWriter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class TestNGReporter
implements ITestListener,
ISuiteListener {
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    protected ReporterManager reportManager;
    private Object source;

    public TestNGReporter(ReporterManager reportManager, SurefireTestSuite source) {
        this.reportManager = reportManager;
        if (reportManager == null) {
            throw new IllegalArgumentException("ReportManager passed in was null.");
        }
        this.source = source;
    }

    public void onTestStart(ITestResult result) {
        String rawString = this.bundle.getString("testStarting");
        String group = TestNGReporter.groupString(result.getMethod().getGroups(), result.getTestClass().getName());
        ReportEntry report = new ReportEntry(this.source, result.getTestClass().getName() + "#" + result.getMethod().getMethodName(), group, rawString);
        this.reportManager.testStarting(report);
    }

    public void onTestSuccess(ITestResult result) {
        ReportEntry report = new ReportEntry(this.source, result.getName(), this.bundle.getString("testSuccessful"));
        this.reportManager.testSucceeded(report);
    }

    public void onTestFailure(ITestResult result) {
        String rawString = this.bundle.getString("executeException");
        ReportEntry report = new ReportEntry(this.source, result.getName(), rawString, (StackTraceWriter)new TestNGStackTraceWriter(result));
        this.reportManager.testFailed(report);
    }

    public void onTestSkipped(ITestResult result) {
        ReportEntry report = new ReportEntry(this.source, result.getName(), this.bundle.getString("testSkipped"));
        this.reportManager.testSkipped(report);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        String rawString = this.bundle.getString("executeException");
        ReportEntry report = new ReportEntry(this.source, result.getName(), rawString, (StackTraceWriter)new TestNGStackTraceWriter(result));
        this.reportManager.testError(report);
    }

    public void onStart(ITestContext context) {
        String rawString = this.bundle.getString("testSetStarting");
        String group = TestNGReporter.groupString(context.getIncludedGroups(), context.getName());
        ReportEntry report = new ReportEntry(this.source, context.getName(), group, rawString);
        try {
            this.reportManager.testSetStarting(report);
        }
        catch (ReporterException e) {
            // empty catch block
        }
    }

    public void onFinish(ITestContext context) {
        String rawString = this.bundle.getString("testSetCompletedNormally");
        ReportEntry report = new ReportEntry(this.source, context.getName(), TestNGReporter.groupString(context.getIncludedGroups(), null), rawString);
        this.reportManager.testSetCompleted(report);
        this.reportManager.reset();
    }

    public void onFinish(ISuite suite) {
    }

    public void onStart(ISuite suite) {
    }

    private static String groupString(String[] groups, String defaultValue) {
        String retVal;
        if (groups != null && groups.length > 0) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                str.append(groups[i]);
                if (i + 1 >= groups.length) continue;
                str.append(",");
            }
            retVal = str.toString();
        } else {
            retVal = defaultValue;
        }
        return retVal;
    }
}

