/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.codehaus.plexus.util.StringUtils;
import org.testng.ITestResult;

public class TestNGStackTraceWriter
extends PojoStackTraceWriter {
    public TestNGStackTraceWriter(ITestResult result) {
        super(result.getTestClass().getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable());
    }

    public String writeTrimmedTraceToString() {
        String text = this.writeTraceToString();
        String marker = "at " + this.testClass + "." + this.testMethod;
        String[] lines = StringUtils.split((String)text, (String)"\n");
        int lastLine = lines.length - 1;
        for (int i = 1; i < lines.length; ++i) {
            if (!lines[i].trim().startsWith(marker)) continue;
            lastLine = i;
        }
        StringBuffer trace = new StringBuffer();
        for (int i = 0; i <= lastLine; ++i) {
            if (lines[i].trim().startsWith("at junit.framework.Assert")) continue;
            trace.append(lines[i]);
            trace.append("\n");
        }
        return trace.toString();
    }
}

