/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.util.ResourceBundle;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class TestNGReporter
implements ITestListener,
ISuiteListener {
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    protected ReporterManager reportManager;
    private Object source;

    public TestNGReporter(ReporterManager reportManager, SurefireTestSuite source) {
        this.reportManager = reportManager;
        if (reportManager == null) {
            throw new IllegalArgumentException("ReportManager passed in was null.");
        }
        this.source = source;
    }

    public void onTestStart(ITestResult result) {
        String rawString = this.bundle.getString("testStarting");
        String group = TestNGReporter.groupString(result.getMethod().getGroups(), result.getTestClass().getName());
        ReportEntry report = new ReportEntry(this.source, TestNGReporter.getUserFriendlyTestName(result), group, rawString);
        this.reportManager.testStarting(report);
    }

    public void onTestSuccess(ITestResult result) {
        ReportEntry report = new ReportEntry(this.source, TestNGReporter.getUserFriendlyTestName(result), this.bundle.getString("testSuccessful"));
        this.reportManager.testSucceeded(report);
    }

    public void onTestFailure(ITestResult result) {
        String rawString = this.bundle.getString("executeException");
        ReportEntry report = new ReportEntry(this.source, TestNGReporter.getUserFriendlyTestName(result), rawString, (StackTraceWriter)new PojoStackTraceWriter(result.getTestClass().getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable()));
        this.reportManager.testFailed(report);
    }

    private static String getUserFriendlyTestName(ITestResult result) {
        return result.getName() + "(" + result.getTestClass().getName() + ")";
    }

    public void onTestSkipped(ITestResult result) {
        ReportEntry report = new ReportEntry(this.source, TestNGReporter.getUserFriendlyTestName(result), this.bundle.getString("testSkipped"));
        this.reportManager.testSkipped(report);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        String rawString = this.bundle.getString("executeException");
        ReportEntry report = new ReportEntry(this.source, TestNGReporter.getUserFriendlyTestName(result), rawString, (StackTraceWriter)new PojoStackTraceWriter(result.getTestClass().getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable()));
        this.reportManager.testError(report);
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
    }

    private static String groupString(String[] groups, String defaultValue) {
        String retVal;
        if (groups != null && groups.length > 0) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                str.append(groups[i]);
                if (i + 1 >= groups.length) continue;
                str.append(",");
            }
            retVal = str.toString();
        } else {
            retVal = defaultValue;
        }
        return retVal;
    }

    public void onConfigurationFailure(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onConfigurationSkip(ITestResult result) {
        this.onTestSkipped(result);
    }

    public void onConfigurationSuccess(ITestResult result) {
    }
}

