/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng.conf;

import java.util.Map;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.testng.conf.TestNG60Configurator;
import org.testng.xml.XmlSuite;

public class TestNG740Configurator
extends TestNG60Configurator {
    @Override
    public void configure(XmlSuite suite, Map<String, String> options) throws TestSetFailedException {
        String dataProviderThreadCount;
        String threadCountAsString = options.get("threadcount");
        int threadCount = threadCountAsString == null ? 1 : Integer.parseInt(threadCountAsString);
        suite.setThreadCount(threadCount);
        String parallel = options.get("parallel");
        if (parallel != null) {
            if (!"methods".equalsIgnoreCase(parallel) && !"classes".equalsIgnoreCase(parallel)) {
                throw new TestSetFailedException("Unsupported TestNG parallel setting: " + parallel + " ( only METHODS or CLASSES supported )");
            }
            Class enumClass = ReflectionUtils.tryLoadClass((ClassLoader)XmlSuite.class.getClassLoader(), (String)"org.testng.xml.XmlSuite$ParallelMode");
            Object parallelEnum = Enum.valueOf(enumClass, parallel.toUpperCase());
            ReflectionUtils.invokeSetter((Object)suite, (String)"setParallel", (Class)enumClass, parallelEnum);
        }
        if ((dataProviderThreadCount = options.get("dataproviderthreadcount")) != null) {
            suite.setDataProviderThreadCount(Integer.parseInt(dataProviderThreadCount));
        }
    }
}

