/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.TestSuite;

final class TestNGDirectoryTestSuite
extends TestSuite {
    private final Map<String, String> options;
    private final Map<String, String> junitOptions;
    private final String testSourceDirectory;
    private final File reportsDirectory;
    private final TestListResolver methodFilter;
    private final Class<?> junitTestClass;
    private final Class<? extends Annotation> junitRunWithAnnotation;
    private final Class<? extends Annotation> junitTestAnnotation;
    private final List<CommandLineOption> mainCliOptions;
    private final int skipAfterFailureCount;

    TestNGDirectoryTestSuite(String testSourceDirectory, Map<String, String> confOptions, File reportsDirectory, TestListResolver methodFilter, List<CommandLineOption> mainCliOptions, int skipAfterFailureCount) {
        this.options = confOptions;
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
        this.methodFilter = methodFilter;
        this.junitTestClass = TestNGDirectoryTestSuite.findJUnitTestClass();
        this.junitRunWithAnnotation = TestNGDirectoryTestSuite.findJUnitRunWithAnnotation();
        this.junitTestAnnotation = TestNGDirectoryTestSuite.findJUnitTestAnnotation();
        this.junitOptions = this.createJUnitOptions();
        this.mainCliOptions = mainCliOptions;
        this.skipAfterFailureCount = skipAfterFailureCount;
    }

    void execute(TestsToRun testsToRun, TestNGReporter testNGReporter) throws TestSetFailedException {
        if (!testsToRun.allowEagerReading()) {
            this.executeLazy(testsToRun, testNGReporter);
        } else if (testsToRun.containsAtLeast(2)) {
            this.executeMulti(testsToRun, testNGReporter);
        } else if (testsToRun.containsAtLeast(1)) {
            Class testClass = (Class)testsToRun.iterator().next();
            this.executeSingleClass(testNGReporter, testClass);
        }
    }

    private void executeSingleClass(TestNGReporter testNGReporter, Class<?> testClass) throws TestSetFailedException {
        this.options.put("suitename", testClass.getName());
        this.startTestSuite(testNGReporter.getRunListener());
        Map<String, String> optionsToUse = this.isJUnitTest(testClass) ? this.junitOptions : this.options;
        TestNGExecutor.run(Collections.singleton(testClass), this.testSourceDirectory, optionsToUse, testNGReporter, this.reportsDirectory, this.methodFilter, this.mainCliOptions, this.skipAfterFailureCount);
        this.finishTestSuite(testNGReporter.getRunListener());
    }

    private void executeLazy(TestsToRun testsToRun, TestNGReporter testNGReporter) throws TestSetFailedException {
        for (Class testToRun : testsToRun) {
            this.executeSingleClass(testNGReporter, testToRun);
        }
    }

    private static Class<?> findJUnitTestClass() {
        return TestNGDirectoryTestSuite.lookupClass("junit.framework.Test");
    }

    private static Class<Annotation> findJUnitRunWithAnnotation() {
        return TestNGDirectoryTestSuite.lookupAnnotation("org.junit.runner.RunWith");
    }

    private static Class<Annotation> findJUnitTestAnnotation() {
        return TestNGDirectoryTestSuite.lookupAnnotation("org.junit.Test");
    }

    private static Class<Annotation> lookupAnnotation(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> lookupClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void executeMulti(TestsToRun testsToRun, TestNGReporter testNGReporter) throws TestSetFailedException {
        ArrayList testNgTestClasses = new ArrayList();
        ArrayList junitTestClasses = new ArrayList();
        for (Class testToRun : testsToRun) {
            if (this.isJUnitTest(testToRun)) {
                junitTestClasses.add(testToRun);
                continue;
            }
            testNgTestClasses.add(testToRun);
        }
        File testNgReportsDirectory = this.reportsDirectory;
        File junitReportsDirectory = this.reportsDirectory;
        if (!junitTestClasses.isEmpty() && !testNgTestClasses.isEmpty()) {
            testNgReportsDirectory = new File(this.reportsDirectory, "testng-native-results");
            junitReportsDirectory = new File(this.reportsDirectory, "testng-junit-results");
        }
        this.startTestSuite(testNGReporter.getRunListener());
        TestNGExecutor.run(testNgTestClasses, this.testSourceDirectory, this.options, testNGReporter, testNgReportsDirectory, this.methodFilter, this.mainCliOptions, this.skipAfterFailureCount);
        if (!junitTestClasses.isEmpty()) {
            TestNGExecutor.run(junitTestClasses, this.testSourceDirectory, this.junitOptions, testNGReporter, junitReportsDirectory, this.methodFilter, this.mainCliOptions, this.skipAfterFailureCount);
        }
        this.finishTestSuite(testNGReporter.getRunListener());
    }

    private boolean isJUnitTest(Class<?> c) {
        return this.isJunit3Test(c) || this.isJunit4Test(c);
    }

    private boolean isJunit4Test(Class<?> c) {
        return this.hasJunit4RunWithAnnotation(c) || this.hasJunit4TestAnnotation(c);
    }

    private boolean hasJunit4RunWithAnnotation(Class<?> c) {
        return this.junitRunWithAnnotation != null && c.getAnnotation(this.junitRunWithAnnotation) != null;
    }

    private boolean hasJunit4TestAnnotation(Class<?> c) {
        if (this.junitTestAnnotation != null) {
            for (Method m : c.getMethods()) {
                if (m.getAnnotation(this.junitTestAnnotation) == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isJunit3Test(Class<?> c) {
        return this.junitTestClass != null && this.junitTestClass.isAssignableFrom(c);
    }

    private Map<String, String> createJUnitOptions() {
        HashMap<String, String> junitOptions = new HashMap<String, String>(this.options);
        String onlyJUnit = this.options.get("junit");
        if (StringUtils.isBlank((String)onlyJUnit)) {
            onlyJUnit = "true";
        }
        junitOptions.put("junit", onlyJUnit);
        return junitOptions;
    }

    @Override
    Map<String, String> getOptions() {
        return this.options;
    }
}

