/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos;

import java.util.Collection;
import org.apache.mesos.MesosNativeLibrary;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;

public class MesosSchedulerDriver
implements SchedulerDriver {
    private final Scheduler scheduler;
    private final Protos.FrameworkInfo framework;
    private final String master;
    private long __scheduler;
    private long __driver;

    public MesosSchedulerDriver(Scheduler scheduler, Protos.FrameworkInfo frameworkInfo, String string) {
        if (scheduler == null) {
            throw new NullPointerException("Not expecting a null Scheduler");
        }
        if (frameworkInfo == null) {
            throw new NullPointerException("Not expecting a null FrameworkInfo");
        }
        if (string == null) {
            throw new NullPointerException("Not expecting a null master");
        }
        this.scheduler = scheduler;
        this.framework = frameworkInfo;
        this.master = string;
        this.initialize();
    }

    @Override
    public native Protos.Status start();

    @Override
    public native Protos.Status stop(boolean var1);

    @Override
    public Protos.Status stop() {
        return this.stop(false);
    }

    @Override
    public native Protos.Status abort();

    @Override
    public native Protos.Status join();

    @Override
    public Protos.Status run() {
        Protos.Status status = this.start();
        return status != Protos.Status.DRIVER_RUNNING ? status : this.join();
    }

    @Override
    public native Protos.Status requestResources(Collection<Protos.Request> var1);

    @Override
    public Protos.Status launchTasks(Protos.OfferID offerID, Collection<Protos.TaskInfo> collection) {
        return this.launchTasks(offerID, collection, Protos.Filters.newBuilder().build());
    }

    @Override
    public native Protos.Status launchTasks(Protos.OfferID var1, Collection<Protos.TaskInfo> var2, Protos.Filters var3);

    @Override
    public native Protos.Status killTask(Protos.TaskID var1);

    @Override
    public Protos.Status declineOffer(Protos.OfferID offerID) {
        return this.declineOffer(offerID, Protos.Filters.newBuilder().build());
    }

    @Override
    public native Protos.Status declineOffer(Protos.OfferID var1, Protos.Filters var2);

    @Override
    public native Protos.Status reviveOffers();

    @Override
    public native Protos.Status sendFrameworkMessage(Protos.ExecutorID var1, Protos.SlaveID var2, byte[] var3);

    protected native void initialize();

    protected native void finalize();

    static {
        MesosNativeLibrary.load();
    }
}

