/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos.state;

import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.mesos.state.State;
import org.apache.mesos.state.Variable;

public class InMemoryState
implements State {
    private final ConcurrentMap<String, Entry> entries = new ConcurrentHashMap<String, Entry>();

    @Override
    public Future<Variable> get(String string) {
        Entry entry = (Entry)this.entries.get(string);
        if (entry == null) {
            entry = new Entry();
            entry.name = string;
            entry.uuid = UUID.randomUUID();
            entry.value = new byte[0];
            this.entries.put(string, entry);
            entry = this.entries.putIfAbsent(string, entry);
        }
        assert (entry != null);
        return InMemoryState.futureFrom(new InMemoryVariable(entry));
    }

    @Override
    public Future<Variable> set(Variable variable) {
        InMemoryVariable inMemoryVariable = (InMemoryVariable)variable;
        Entry entry = new Entry();
        entry.name = inMemoryVariable.entry.name;
        entry.uuid = UUID.randomUUID();
        entry.value = inMemoryVariable.value;
        if (this.entries.replace(entry.name, inMemoryVariable.entry, entry)) {
            return InMemoryState.futureFrom(new InMemoryVariable(entry));
        }
        return InMemoryState.futureFrom(null);
    }

    @Override
    public Future<Iterator<String>> names() {
        return InMemoryState.futureFrom(this.entries.keySet().iterator());
    }

    private static <T> Future<T> futureFrom(final T t) {
        FutureTask futureTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() {
                return t;
            }
        });
        futureTask.run();
        return futureTask;
    }

    private static class Entry {
        String name;
        UUID uuid;
        byte[] value;

        private Entry() {
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                return this.uuid.equals(((Entry)object).uuid);
            }
            return false;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }
    }

    private static class InMemoryVariable
    extends Variable {
        final Entry entry;
        final byte[] value;

        private InMemoryVariable(Entry entry) {
            this(entry, (byte[])null);
        }

        private InMemoryVariable(Entry entry, byte[] byArray) {
            this.entry = entry;
            this.value = byArray;
        }

        @Override
        public byte[] value() {
            if (this.value != null) {
                return this.value;
            }
            return this.entry.value;
        }

        @Override
        public Variable mutate(byte[] byArray) {
            return new InMemoryVariable(this.entry, byArray);
        }
    }
}

