/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.mesos.MesosNativeLibrary;

public class Log {
    private long __log;

    public Log(int n, String string, Set<String> set) {
        this.initialize(n, string, set);
    }

    public Log(int n, String string, String string2, long l, TimeUnit timeUnit, String string3) {
        this.initialize(n, string, string2, l, timeUnit, string3);
    }

    public Log(int n, String string, String string2, long l, TimeUnit timeUnit, String string3, String string4, byte[] byArray) {
        this.initialize(n, string, string2, l, timeUnit, string3, string4, byArray);
    }

    public Position position(byte[] byArray) {
        long l = (long)(byArray[0] & 0xFF) << 56 | (long)(byArray[1] & 0xFF) << 48 | (long)(byArray[2] & 0xFF) << 40 | (long)(byArray[3] & 0xFF) << 32 | (long)(byArray[4] & 0xFF) << 24 | (long)(byArray[5] & 0xFF) << 16 | (long)(byArray[6] & 0xFF) << 8 | (long)(byArray[7] & 0xFF);
        return new Position(l);
    }

    protected native void initialize(int var1, String var2, Set<String> var3);

    protected native void initialize(int var1, String var2, String var3, long var4, TimeUnit var6, String var7);

    protected native void initialize(int var1, String var2, String var3, long var4, TimeUnit var6, String var7, String var8, byte[] var9);

    protected native void finalize();

    static {
        MesosNativeLibrary.load();
    }

    public static class Writer {
        private Log log;
        private long __log;
        private long __writer;

        public Writer(Log log, long l, TimeUnit timeUnit, int n) {
            this.log = log;
            this.initialize(log, l, timeUnit, n);
        }

        public native Position append(byte[] var1, long var2, TimeUnit var4) throws TimeoutException, WriterFailedException;

        public native Position truncate(Position var1, long var2, TimeUnit var4) throws TimeoutException, WriterFailedException;

        protected native void initialize(Log var1, long var2, TimeUnit var4, int var5);

        protected native void finalize();
    }

    public static class Reader {
        private Log log;
        private long __log;
        private long __reader;

        public Reader(Log log) {
            this.log = log;
            this.initialize(log);
        }

        public native List<Entry> read(Position var1, Position var2, long var3, TimeUnit var5) throws TimeoutException, OperationFailedException;

        public native Position beginning();

        public native Position ending();

        protected native void initialize(Log var1);

        protected native void finalize();
    }

    public static class WriterFailedException
    extends Exception {
        public WriterFailedException(String string) {
            super(string);
        }

        public WriterFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class OperationFailedException
    extends Exception {
        public OperationFailedException(String string) {
            super(string);
        }

        public OperationFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class Entry {
        public final Position position;
        public final byte[] data;

        private Entry(Position position, byte[] byArray) {
            this.position = position;
            this.data = byArray;
        }
    }

    public static class Position
    implements Comparable<Position> {
        private final long value;

        @Override
        public int compareTo(Position position) {
            return Long.signum(this.value - position.value);
        }

        public boolean equals(Object object) {
            return object instanceof Position && this.value == ((Position)object).value;
        }

        public String toString() {
            return "Position " + this.value;
        }

        public byte[] identity() {
            byte[] byArray = new byte[]{(byte)(0xFFL & this.value >> 56), (byte)(0xFFL & this.value >> 48), (byte)(0xFFL & this.value >> 40), (byte)(0xFFL & this.value >> 32), (byte)(0xFFL & this.value >> 24), (byte)(0xFFL & this.value >> 16), (byte)(0xFFL & this.value >> 8), (byte)(0xFFL & this.value)};
            return byArray;
        }

        private Position(long l) {
            this.value = l;
        }
    }
}

